/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openxma.dsl.platform.assembler.DtoAssembler;
import org.openxma.dsl.platform.assembler.DtoAssemblerRegistry;
import org.openxma.dsl.platform.dao.EntityFactoryRegistry;
import org.openxma.dsl.platform.service.Mapper;
import org.openxma.dsl.platform.service.MapperContextHolder;
import org.openxma.dsl.platform.service.impl.MappingCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class EntitySupportMapper
implements Mapper {
    @Autowired
    private EntityFactoryRegistry entityFactoryRegistry;
    @Autowired
    private DtoAssemblerRegistry dtoAssemblerRegistry;

    @Override
    public <T> List<T> createAndMapMany(Collection<?> sourceCollection, Class<T> targetClass) {
        return this.createAndMapMany(sourceCollection, targetClass, new HashMap());
    }

    @Override
    public <T> T mapOne(Object sourceObject, T targetObject) {
        return this.mapOne(sourceObject, targetObject, new HashMap());
    }

    @Override
    public <T> T createAndMapOne(Object sourceObject, Class<T> targetClass) {
        return this.createAndMapOne(sourceObject, targetClass, new HashMap());
    }

    @Override
    public <T> T createAndMapOne(Object sourceObject, Class<T> targetClass, Object context) {
        if (null == targetClass) {
            throw new IllegalArgumentException("parameter 'targetClass' must not be null");
        }
        if (null == sourceObject) {
            return null;
        }
        Object newSourceObject = this.extractSourceObjectFromCollection(sourceObject);
        if (null == newSourceObject) {
            return null;
        }
        return this.executeCreateAndMapOne(newSourceObject, targetClass, context);
    }

    private <T> T executeCreateAndMapOne(final Object sourceObject, final Class<T> targetClass, final Object context) {
        return this.execute(new MappingCommand<T>(){

            @Override
            public T execute() {
                return EntitySupportMapper.this.createAndMapOneInternal(sourceObject, targetClass);
            }

            @Override
            public Object getContext() {
                return context;
            }
        });
    }

    private Object extractSourceObjectFromCollection(Object sourceObject) {
        if (!(sourceObject instanceof Collection)) {
            return sourceObject;
        }
        Collection sourceCollection = (Collection)sourceObject;
        if (sourceCollection.isEmpty()) {
            return null;
        }
        return sourceCollection.iterator().next();
    }

    private <T> T createAndMapOneInternal(Object sourceObject, Class<T> targetClass) {
        DtoAssembler<T> targetDtoAssembler = this.dtoAssemblerRegistry.getDtoAssembler(targetClass);
        DtoAssembler<?> sourceDtoAssembler = this.dtoAssemblerRegistry.getDtoAssembler(sourceObject.getClass());
        if (MapperContextHolder.isMapperOperation() || null != sourceDtoAssembler) {
            return sourceDtoAssembler.mapTo(sourceObject, targetClass);
        }
        if (null != targetDtoAssembler) {
            return targetDtoAssembler.mapFromEntity(sourceObject);
        }
        throw new IllegalArgumentException("missing DtoAssembler");
    }

    @Override
    public <T> List<T> createAndMapMany(Collection<?> sourceCollection, Class<T> targetClass, Object context) {
        if (null == targetClass) {
            throw new IllegalArgumentException("parameter 'targetClass' must not be null");
        }
        ArrayList<T> result = new ArrayList<T>();
        if (null == sourceCollection) {
            return result;
        }
        for (Object object : sourceCollection) {
            T mapOne = this.createAndMapOne(object, targetClass, context);
            if (mapOne == null) continue;
            result.add(mapOne);
        }
        return result;
    }

    @Override
    public <T> T mapOne(Object sourceObject, T targetObject, Object context) {
        if (null == targetObject) {
            throw new IllegalArgumentException("parameter 'targetObject' must not be null");
        }
        if (null == sourceObject) {
            return targetObject;
        }
        return this.executeMapOne(sourceObject, targetObject, context);
    }

    private <T> T executeMapOne(final Object sourceObject, final T targetObject, final Object context) {
        return this.execute(new MappingCommand<T>(){

            @Override
            public T execute() {
                return EntitySupportMapper.this.mapOneInternal(sourceObject, targetObject);
            }

            @Override
            public Object getContext() {
                return context;
            }
        });
    }

    private <T> T mapOneInternal(Object sourceObject, T targetObject) {
        DtoAssembler<?> targetDtoAssembler = this.dtoAssemblerRegistry.getDtoAssembler(targetObject.getClass());
        DtoAssembler<?> sourceDtoAssembler = this.dtoAssemblerRegistry.getDtoAssembler(sourceObject.getClass());
        if (MapperContextHolder.isMapperOperation() || null != sourceDtoAssembler) {
            sourceDtoAssembler.mapTo(sourceObject, targetObject);
        } else if (null != targetDtoAssembler) {
            targetObject = targetDtoAssembler.mapFromEntity(sourceObject, targetObject);
        } else {
            throw new IllegalArgumentException("missing DtoAssembler");
        }
        return targetObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(MappingCommand<T> mappingCommand) {
        MapperContextHolder.setRegistryWithContext(this.entityFactoryRegistry, this.getContextMap(mappingCommand.getContext()), false);
        try {
            T t = mappingCommand.execute();
            return t;
        }
        finally {
            MapperContextHolder.reset();
        }
    }

    private Map<Object, Object> getContextMap(Object context) {
        HashMap<Object, Object> result = new HashMap();
        if (context instanceof Map) {
            result = (Map)context;
        } else if (null != context) {
            result.put("context", context);
        }
        return result;
    }
}

