/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.validation;

import at.spardat.enterprise.exc.SysException;
import at.spardat.enterprise.fmt.FmtFactory;
import at.spardat.enterprise.fmt.FmtParseException;
import at.spardat.enterprise.fmt.IFmt;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Validators
implements Validator {
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULT_VALUES = new HashMap();

    public <T> T getValue(Object object, String property, Class<T> propertyType) {
        Assert.notNull((Object)object, (String)"parameter 'object' must not be null");
        Assert.notNull((Object)property, (String)"parameter 'property' must not be null");
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(object);
        Object value = beanWrapper.getPropertyValue(property);
        if (value == null && ClassUtils.isPrimitiveWrapper(propertyType)) {
            value = PRIMITIVE_DEFAULT_VALUES.get(propertyType);
        }
        return propertyType.cast(value);
    }

    public void rejectIfMaxLength(Errors errors, String name, String value, int maxLength) {
        if (value != null && value.trim().length() > maxLength) {
            errors.rejectValue(name, "field.max.length", new Object[]{name, value, maxLength}, "Attribute '" + name + "' must have at most [" + maxLength + "] characters.");
        }
    }

    public void rejectIfMinLength(Errors errors, String name, String value, int minLength) {
        if (value != null && value.trim().length() < minLength) {
            errors.rejectValue(name, "field.min.length", new Object[]{name, value, minLength}, "Attribute '" + name + "' must have at least [" + minLength + "] characters.");
        }
    }

    public void rejectIfMaxValue(Errors errors, String name, Number value, int maxValue) {
        if (value != null && value.intValue() > maxValue) {
            errors.rejectValue(name, "field.max.value", new Object[]{name, value, maxValue}, "Attribute '" + name + "' must not be bigger than [" + maxValue + "].");
        }
    }

    public void rejectIfMinValue(Errors errors, String name, Number value, int minValue) {
        if (value != null && value.intValue() < minValue) {
            errors.rejectValue(name, "field.min.value", new Object[]{name, value, minValue}, "Attribute '" + name + "' must not be smaller than [" + minValue + "].");
        }
    }

    public void rejectIfMaxIntegerDigits(Errors errors, String name, Number value, int maxIntegerDigits) {
        BigDecimal bigDecimal = this.toBigDecimal(value);
        int integerPartLength = bigDecimal.precision() - bigDecimal.scale();
        if (integerPartLength > maxIntegerDigits) {
            errors.rejectValue(name, "field.max.integer.digits", new Object[]{name, value, maxIntegerDigits}, "Attribute '" + name + "' must have at most [" + maxIntegerDigits + "] digits in the integer portion.");
        }
    }

    public void rejectIfMaxFractionDigits(Errors errors, String name, Number value, int maxFractionalDigits) {
        int fractionPartLength;
        BigDecimal bigDecimal = this.toBigDecimal(value);
        int n = fractionPartLength = bigDecimal.scale() < 0 ? 0 : bigDecimal.scale();
        if (fractionPartLength > maxFractionalDigits) {
            errors.rejectValue(name, "field.max.fractional.digits", new Object[]{name, value, maxFractionalDigits}, "Attribute '" + name + "' must have at most [" + maxFractionalDigits + "] digits in the fraction portion.");
        }
    }

    public void rejectIfInvalidFormat(Errors errors, String name, String value, String format) {
        this.rejectIfInvalidFormat(errors, name, value, FmtFactory.create((String)format, (Locale)this.getLocale()));
    }

    public void rejectIfInvalidFormat(Errors errors, String name, String value, IFmt format) {
        try {
            format.parse(value);
        }
        catch (FmtParseException fmtParseException) {
            errors.rejectValue(name, this.getErrorCode(fmtParseException), fmtParseException.getUIMessage(this.getLocale()));
        }
    }

    protected Errors createErrors(Object target) {
        Assert.notNull((Object)target, (String)"parameter 'target' must not be null");
        BeanPropertyBindingResult beanPropertyBindingResult = new BeanPropertyBindingResult(target, target.getClass().getSimpleName());
        beanPropertyBindingResult.setMessageCodesResolver(this.getMessageCodeResolver());
        return beanPropertyBindingResult;
    }

    protected MessageCodesResolver getMessageCodeResolver() {
        return new DefaultMessageCodesResolver();
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    protected BigDecimal toBigDecimal(Number value) {
        BigDecimal result = null;
        if (value instanceof BigDecimal) {
            result = (BigDecimal)value;
        } else if (value != null) {
            result = new BigDecimal(value.toString());
        }
        return null != result ? result.stripTrailingZeros() : BigDecimal.ZERO;
    }

    private String getErrorCode(FmtParseException fmtParseException) {
        try {
            return (String)((Object)((Object)fmtParseException)).getClass().getField("bundleKey_").get((Object)fmtParseException);
        }
        catch (Exception e) {
            throw new SysException((Throwable)e);
        }
    }

    static {
        PRIMITIVE_DEFAULT_VALUES.put(Integer.class, new Integer(0));
        PRIMITIVE_DEFAULT_VALUES.put(Boolean.class, Boolean.FALSE);
        PRIMITIVE_DEFAULT_VALUES.put(Short.class, new Short(0));
        PRIMITIVE_DEFAULT_VALUES.put(Byte.class, new Byte(0));
        PRIMITIVE_DEFAULT_VALUES.put(Character.class, new Character('\u0000'));
        PRIMITIVE_DEFAULT_VALUES.put(Long.class, new Long(0L));
        PRIMITIVE_DEFAULT_VALUES.put(Double.class, new Double(0.0));
        PRIMITIVE_DEFAULT_VALUES.put(Float.class, new Float(0.0f));
    }
}

