/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.xma;

import at.spardat.enterprise.exc.AppException;
import at.spardat.enterprise.exc.SysException;
import at.spardat.xma.page.PageServer;
import at.spardat.xma.session.XMASessionServer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.openxma.dsl.platform.exceptions.ApplicationException;
import org.openxma.dsl.platform.exceptions.SystemException;
import org.openxma.dsl.platform.i18n.MessageProvider;
import org.openxma.dsl.platform.i18n.SimpleErrorMessageProvider;
import org.openxma.dsl.platform.xma.DslComponentServer;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class SpringComponentServer
extends DslComponentServer {
    protected ApplicationContext applicationContext;
    protected MessageProvider messageProvider = new SimpleErrorMessageProvider();

    public SpringComponentServer(XMASessionServer session, boolean isStateless, short id) {
        super(session, isStateless, id);
        this.applicationContext = this.getWebApplicationContext();
        this.applicationContext.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 4, true);
    }

    public PageServer newPageModel(short typeId) {
        PageServer newPageModel = super.newPageModel(typeId);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBeanProperties((Object)newPageModel, 4, true);
        return newPageModel;
    }

    public Object getBean(String name) {
        return this.getWebApplicationContext().getBean(name);
    }

    public WebApplicationContext getWebApplicationContext() {
        HttpSession httpSession = this.getSession().getHttpSession();
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)httpSession.getServletContext());
        return webApplicationContext;
    }

    public Throwable convertToBaseException(Throwable detail) {
        if (detail instanceof ApplicationException) {
            return new AppException(detail, this.messageProvider.getMessage((ApplicationException)detail, this.getSession().getContext().getLocale()));
        }
        if (detail instanceof SystemException) {
            return new SysException(detail, this.messageProvider.getMessage((SystemException)detail, this.getSession().getContext().getLocale()));
        }
        return super.convertToBaseException(detail);
    }

    public void setMessageProvider(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }
}

