/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.xma.client.browse;

import at.spardat.xma.mdl.IWModelClient;
import at.spardat.xma.mdl.UIDelegateClient;
import at.spardat.xma.mdl.WModel;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.openxma.dsl.platform.xma.client.browse.BrowseableUIDelegateClient;
import org.openxma.dsl.platform.xma.client.browse.BrowseableWMClient;

public class BrowseMode {
    public static final byte DEFAULT = 0;
    public static final byte FOREGROUND = 1;
    public static final byte BACKGROUND = 2;
    public static final byte FONT = 4;
    public static final byte TEXT = 16;
    private static BrowseMode instance;

    public static BrowseMode getInstance() {
        if (instance == null) {
            instance = new BrowseMode();
        }
        return instance;
    }

    public Control createBrowseWidget(Control editControl, int style) {
        Label browseControl = null;
        if ((style & 0x10) != 0) {
            Text text = new Text(editControl.getParent(), 18432);
            text.setEditable(false);
            browseControl = text;
        } else {
            browseControl = new Label(editControl.getParent(), 16448);
        }
        if ((style & 2) != 0) {
            browseControl.setBackground(editControl.getBackground());
        }
        if ((style & 1) != 0) {
            browseControl.setForeground(editControl.getForeground());
        }
        if ((style & 4) != 0) {
            browseControl.setFont(editControl.getFont());
        }
        FormData parentData = (FormData)editControl.getLayoutData();
        FormData data = this.cloneFormData(parentData);
        browseControl.setLayoutData((Object)data);
        return browseControl;
    }

    public void attachBrowseWidget(IWModelClient wModel, Control browseControl) {
        UIDelegateClient uiDelegate = wModel.getUIDelegate();
        if (!(uiDelegate instanceof BrowseableUIDelegateClient)) {
            throw new IllegalArgumentException("The ui-delegete of the widget model has to be of instance 'BrowseUIDelegateClient'");
        }
        ((BrowseableUIDelegateClient)uiDelegate).attachBrowseControl(browseControl);
    }

    protected FormData cloneFormData(FormData parentData) {
        FormData data = new FormData();
        data.left = parentData.left;
        data.top = parentData.top;
        data.bottom = parentData.bottom;
        data.right = parentData.right;
        data.width = parentData.width;
        data.height = parentData.height;
        return data;
    }

    public void detachBrowseControls(WModel[] wModels) {
        for (int i = wModels.length - 1; i >= 0; --i) {
            UIDelegateClient uIDelegateClient;
            if (!(wModels[i] instanceof BrowseableWMClient) || !((uIDelegateClient = ((IWModelClient)wModels[i]).getUIDelegate()) instanceof BrowseableUIDelegateClient)) continue;
            ((BrowseableUIDelegateClient)uIDelegateClient).detachBrowseControl();
        }
    }

    public static void updateBrowseControl(Control browseControl, String text) {
        if (text != null) {
            if (browseControl instanceof Label) {
                ((Label)browseControl).setText(text);
            } else if (browseControl instanceof Text) {
                ((Text)browseControl).setText(text);
            }
        }
    }
}

