/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.xma.client.table;

import at.spardat.xma.mdl.table.ITableWMClient;
import at.spardat.xma.mdl.table.TableLayoutManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.openxma.dsl.platform.xma.client.table.ColumnInfo;

public class TableState {
    int[] originalColumnOrder;
    boolean[] stateValues;
    boolean[] newStateValues;
    List<ColumnInfo> columStates;
    Table tableWidget;
    ITableWMClient tableModel;
    TableLayoutManager tableLayoutManager;

    TableState(TableLayoutManager tableLayoutManager, Table tableWidget, ITableWMClient table, int[] originalColumnOrder) {
        this.originalColumnOrder = originalColumnOrder;
        this.columStates = new ArrayList<ColumnInfo>();
        for (int i = 0; i < originalColumnOrder.length; ++i) {
            ColumnInfo columnState = new ColumnInfo();
            columnState.index = originalColumnOrder[i];
            columnState.minWidth = tableLayoutManager.getMinWidth(columnState.index);
            columnState.absoluteWidth = tableLayoutManager.getAbsolutWidth(columnState.index);
            columnState.percent = Float.valueOf(tableLayoutManager.getPercent(columnState.index));
            TableColumn columnWidget = tableWidget.getColumn(TableState.getCorrectedIndex(table, columnState.index));
            columnState.label = columnWidget.getText();
            int correctedIndex = TableState.getCorrectedIndex(table, columnState.index);
            columnState.resizeable = tableWidget.getColumn(correctedIndex).getResizable();
            this.columStates.add(columnState);
        }
    }

    public boolean hasStateChanged(boolean[] stateValues) {
        this.newStateValues = stateValues;
        if (this.stateValues == null) {
            this.stateValues = stateValues;
            return true;
        }
        if (this.stateValues.length != stateValues.length) {
            this.stateValues = stateValues;
            return true;
        }
        for (int i = 0; i < stateValues.length; ++i) {
            if (this.stateValues[i] == stateValues[i]) continue;
            return true;
        }
        return false;
    }

    public void showColumns(ColumnInfo[] activeColumnStates) {
        int[] vc = new int[activeColumnStates.length];
        for (int i = 0; i < activeColumnStates.length; ++i) {
            vc[i] = activeColumnStates[i].index;
        }
        for (ColumnInfo columnState : this.columStates) {
            boolean isVisible = false;
            ColumnInfo currentColumnState = null;
            for (ColumnInfo visibleColumnState : activeColumnStates) {
                if (visibleColumnState.index != columnState.index) continue;
                currentColumnState = visibleColumnState;
                isVisible = true;
                break;
            }
            if (isVisible) {
                TableState.showTableColumn(this.tableLayoutManager, this.tableWidget, this.tableModel, columnState, currentColumnState);
                continue;
            }
            TableState.hideTableColumn(this.tableLayoutManager, this.tableWidget, this.tableModel, columnState);
        }
        int[] columnsToHide = TableState.getColumnsToHide(this.originalColumnOrder, vc);
        int[] newSortOrder = TableState.getNewSortOrder(vc, columnsToHide);
        this.tableWidget.setColumnOrder(newSortOrder);
        this.stateValues = this.newStateValues;
        this.newStateValues = null;
        this.tableLayoutManager.layout();
    }

    private static int[] getNewSortOrder(int[] visibleSearchColumns, int[] columnsToHide) {
        int[] newSortOrder = new int[visibleSearchColumns.length + columnsToHide.length];
        int newSortOrderIndex = 0;
        for (int visible : visibleSearchColumns) {
            newSortOrder[newSortOrderIndex++] = visible;
        }
        for (int hide : columnsToHide) {
            newSortOrder[newSortOrderIndex++] = hide;
        }
        return newSortOrder;
    }

    private static int[] getColumnsToHide(int[] originalColumnOrder, int[] visibleSearchColumns) {
        int[] columnsToHide = new int[originalColumnOrder.length - visibleSearchColumns.length];
        int hideIndex = 0;
        for (int originalIndex : originalColumnOrder) {
            boolean isOriginalIndexVisible = false;
            for (int visible : visibleSearchColumns) {
                if (visible != originalIndex) continue;
                isOriginalIndexVisible = true;
            }
            if (isOriginalIndexVisible) continue;
            columnsToHide[hideIndex++] = originalIndex;
        }
        return columnsToHide;
    }

    private static void showTableColumn(TableLayoutManager tableLayoutManager, Table tableWidget, ITableWMClient table, ColumnInfo defaultColumnState, ColumnInfo currentColumnState) {
        int correctedIndex = TableState.getCorrectedIndex(table, defaultColumnState.index);
        Integer absoluteWidthToSet = currentColumnState.absoluteWidth != null ? currentColumnState.absoluteWidth : defaultColumnState.absoluteWidth;
        Float percentToSet = currentColumnState.percent != null ? currentColumnState.percent : defaultColumnState.percent;
        tableLayoutManager.setMinWidth(correctedIndex, defaultColumnState.minWidth.intValue());
        tableLayoutManager.setAbsolutWidth(correctedIndex, absoluteWidthToSet.intValue());
        if (percentToSet != null && percentToSet.floatValue() >= 0.0f) {
            tableLayoutManager.setPercent(correctedIndex, percentToSet.floatValue());
        }
        tableWidget.getColumn(correctedIndex).setResizable(defaultColumnState.resizeable.booleanValue());
        String labelToSet = currentColumnState.label != null ? currentColumnState.label : defaultColumnState.label;
        TableColumn columnWidget = tableWidget.getColumn(correctedIndex);
        columnWidget.setText(labelToSet);
    }

    private static void hideTableColumn(TableLayoutManager tableLayoutManager, Table tableWidget, ITableWMClient table, ColumnInfo columnState) {
        int correctedIndex = TableState.getCorrectedIndex(table, columnState.index);
        tableLayoutManager.setMinWidth(correctedIndex, 0);
        tableLayoutManager.setAbsolutWidth(correctedIndex, 0);
        tableWidget.getColumn(correctedIndex).setResizable(false);
    }

    public static int getCorrectedIndex(ITableWMClient table, int columnIndex) {
        int correctedIndex = 0;
        for (int i = 0; i < columnIndex; ++i) {
            if (!table.isVisible(i)) continue;
            ++correctedIndex;
        }
        return correctedIndex;
    }
}

