/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.codehaus.plexus.classworlds.UrlUtils;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.strategy.AbstractStrategy;

public class DefaultStrategy
extends AbstractStrategy {
    public DefaultStrategy(ClassRealm realm) {
        super(realm);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.codehaus.plexus.classworlds.") || name.startsWith("org.codehaus.classworlds.")) {
            return this.realm.getWorld().getClass().getClassLoader().loadClass(name);
        }
        try {
            ClassRealm sourceRealm = this.realm.locateSourceRealm(name);
            if (sourceRealm != this.realm) {
                try {
                    return sourceRealm.loadRealmClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return this.realm.loadRealmClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.realm.getParentRealm() != null) {
                return this.realm.getParentRealm().loadClass(name);
            }
            throw e;
        }
    }

    public URL getResource(String name) {
        name = this.getNormalizedResource(name);
        URL resource = null;
        ClassRealm sourceRealm = this.realm.locateSourceRealm(name);
        if (!sourceRealm.equals(this.realm)) {
            resource = sourceRealm.getResource(name);
        }
        if (resource == null) {
            resource = this.realm.getRealmResource(name);
        }
        if (resource == null && this.realm.getParent() != null) {
            resource = this.realm.getParentRealm().getRealmResource(name);
        }
        return resource;
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        InputStream is = null;
        if (url != null) {
            try {
                is = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return is;
    }

    public Enumeration findResources(String name) throws IOException {
        name = UrlUtils.normalizeUrlPath(name);
        Vector resources = new Vector();
        ClassRealm sourceRealm = this.realm.locateSourceRealm(name);
        if (sourceRealm != this.realm) {
            Enumeration res = sourceRealm.findRealmResources(name);
            while (res.hasMoreElements()) {
                resources.addElement(res.nextElement());
            }
        }
        Enumeration direct = this.realm.findRealmResources(name);
        while (direct.hasMoreElements()) {
            resources.addElement(direct.nextElement());
        }
        if (this.realm.getParentRealm() != null) {
            Enumeration parent = this.realm.getParentRealm().findRealmResources(name);
            while (parent.hasMoreElements()) {
                resources.addElement(parent.nextElement());
            }
        }
        return resources.elements();
    }
}

