/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.ModuleInfoParser;
import org.codehaus.plexus.languages.java.version.JavaVersion;

abstract class AbstractBinaryModuleInfoParser
implements ModuleInfoParser {
    AbstractBinaryModuleInfoParser() {
    }

    @Override
    public JavaModuleDescriptor getModuleDescriptor(Path modulePath) throws IOException {
        return this.getModuleDescriptor(modulePath, JavaVersion.JAVA_SPECIFICATION_VERSION);
    }

    @Override
    public JavaModuleDescriptor getModuleDescriptor(Path modulePath, JavaVersion jdkVersion) throws IOException {
        JavaModuleDescriptor descriptor;
        if (Files.isDirectory(modulePath, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(modulePath.resolve("module-info.class"), new OpenOption[0]);){
                descriptor = this.parse(in);
            }
        }
        try (JarFile jarFile = new JarFile(modulePath.toFile());){
            JarEntry moduleInfo;
            if (modulePath.toString().toLowerCase().endsWith(".jmod")) {
                moduleInfo = jarFile.getJarEntry("classes/module-info.class");
            } else {
                Manifest manifest;
                moduleInfo = jarFile.getJarEntry("module-info.class");
                if (moduleInfo == null && (manifest = jarFile.getManifest()) != null && "true".equalsIgnoreCase(manifest.getMainAttributes().getValue("Multi-Release"))) {
                    int javaVersion;
                    for (int version = javaVersion = Integer.parseInt(jdkVersion.asMajor().getValue(1)); version >= 9; --version) {
                        String resource = "META-INF/versions/" + version + "/module-info.class";
                        JarEntry entry = jarFile.getJarEntry(resource);
                        if (entry == null) continue;
                        moduleInfo = entry;
                        break;
                    }
                }
            }
            descriptor = moduleInfo != null ? this.parse(jarFile.getInputStream(moduleInfo)) : null;
        }
        return descriptor;
    }

    abstract JavaModuleDescriptor parse(InputStream var1) throws IOException;
}

