/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.Date;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;

public class ProjectConfigurator
implements BatchComponent {
    private DatabaseSession databaseSession;
    private Settings settings;

    public ProjectConfigurator(DatabaseSession databaseSession, Settings settings) {
        this.databaseSession = databaseSession;
        this.settings = settings;
    }

    public Project create(ProjectDefinition definition) {
        Project project = new Project(definition.getKey(), this.loadProjectBranch(), definition.getName());
        project.setDescription(StringUtils.defaultString((String)definition.getDescription()));
        project.setPackaging("jar");
        for (Object component : definition.getContainerExtensions()) {
            if (!(component instanceof MavenProject)) continue;
            MavenProject pom = (MavenProject)component;
            project.setPom(pom);
            project.setPackaging(pom.getPackaging());
        }
        return project;
    }

    String loadProjectBranch() {
        return this.settings.getString("sonar.branch");
    }

    public ProjectConfigurator configure(Project project) {
        Date analysisDate = this.loadAnalysisDate();
        project.setConfiguration((Configuration)new PropertiesConfiguration()).setAnalysisDate(analysisDate).setLatestAnalysis(this.isLatestAnalysis(project.getKey(), analysisDate)).setAnalysisVersion(this.loadAnalysisVersion()).setAnalysisType(this.loadAnalysisType()).setLanguageKey(this.loadLanguageKey());
        return this;
    }

    boolean isLatestAnalysis(String projectKey, Date analysisDate) {
        ResourceModel persistedProject = (ResourceModel)this.databaseSession.getSingleResult(ResourceModel.class, new Object[]{"key", projectKey, "enabled", true});
        if (persistedProject != null) {
            Snapshot lastSnapshot = (Snapshot)this.databaseSession.getSingleResult(Snapshot.class, new Object[]{"resourceId", persistedProject.getId(), "last", true});
            return lastSnapshot == null || lastSnapshot.getCreatedAt().before(analysisDate);
        }
        return true;
    }

    Date loadAnalysisDate() {
        Date date = null;
        try {
            date = this.settings.getDateTime("sonar.projectDate");
        }
        catch (SonarException e) {
            date = this.settings.getDate("sonar.projectDate");
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    Project.AnalysisType loadAnalysisType() {
        String value = this.settings.getString("sonar.dynamicAnalysis");
        if (value == null) {
            return "true".equals(this.settings.getString("sonar.light")) ? Project.AnalysisType.STATIC : Project.AnalysisType.DYNAMIC;
        }
        if ("true".equals(value)) {
            return Project.AnalysisType.DYNAMIC;
        }
        if ("reuseReports".equals(value)) {
            return Project.AnalysisType.REUSE_REPORTS;
        }
        return Project.AnalysisType.STATIC;
    }

    String loadAnalysisVersion() {
        return this.settings.getString("sonar.projectVersion");
    }

    String loadLanguageKey() {
        return StringUtils.defaultIfBlank((String)this.settings.getString("sonar.language"), (String)"java");
    }
}

