/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ProfileLoader;
import org.sonar.jpa.dao.ProfilesDao;

public class DefaultProfileLoader
implements ProfileLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProfileLoader.class);
    private ProfilesDao dao;

    public DefaultProfileLoader(ProfilesDao dao) {
        this.dao = dao;
    }

    @Override
    public RulesProfile load(Project project, Settings settings) {
        String profileName = StringUtils.defaultIfBlank((String)settings.getString("sonar.profile"), (String)settings.getString("sonar.profile." + project.getLanguageKey()));
        if (StringUtils.isBlank((String)profileName)) {
            String msg = "You must install a plugin that supports the language key '" + project.getLanguageKey() + "'.";
            msg = !LOG.isDebugEnabled() ? msg + " Run analysis in verbose mode to see list of available language keys." : msg + " See analysis log for a list of available language keys.";
            throw new SonarException(msg);
        }
        RulesProfile profile = this.dao.getProfile(project.getLanguageKey(), profileName);
        if (profile == null) {
            throw new SonarException("Quality profile not found : " + profileName + ", language " + project.getLanguageKey());
        }
        return this.hibernateHack(profile);
    }

    private RulesProfile hibernateHack(RulesProfile profile) {
        profile.getActiveRules().size();
        for (ActiveRule activeRule : profile.getActiveRules()) {
            activeRule.getActiveRuleParams().size();
            activeRule.getRule().getParams().size();
        }
        profile.getAlerts().size();
        return profile;
    }
}

