/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.batch.bootstrap.BootstrapSettings;

public class AnalysisMode
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisMode.class);
    private boolean preview;
    private boolean incremental;

    public AnalysisMode(BootstrapSettings bootstrapSettings) {
        this.init(bootstrapSettings);
    }

    public boolean isPreview() {
        return this.preview || this.incremental;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    private void init(BootstrapSettings bootstrapSettings) {
        if (bootstrapSettings.properties().containsKey("sonar.dryRun")) {
            LOG.warn(MessageFormat.format("Property {0} is deprecated. Please use {1} instead.", "sonar.dryRun", "sonar.analysis.mode"));
            this.preview = "true".equals(bootstrapSettings.property("sonar.dryRun"));
            this.incremental = false;
        } else {
            String mode = bootstrapSettings.property("sonar.analysis.mode");
            this.preview = "preview".equals(mode);
            this.incremental = "incremental".equals(mode);
        }
        if (this.incremental) {
            LOG.info("Incremental mode");
        } else if (this.preview) {
            LOG.info("Preview mode");
        }
        if (this.incremental || this.preview) {
            bootstrapSettings.properties().put("sonar.dryRun", "true");
        }
    }
}

