/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import java.util.Date;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.database.model.Snapshot;

public class PastSnapshot {
    private int index;
    private String mode;
    private String modeParameter;
    private Snapshot projectSnapshot;
    private Date targetDate = null;

    public PastSnapshot(String mode, @Nullable Date targetDate, @Nullable Snapshot projectSnapshot) {
        this.mode = mode;
        if (targetDate != null) {
            this.targetDate = DateUtils.truncate((Date)targetDate, (int)13);
        }
        this.projectSnapshot = projectSnapshot;
    }

    public PastSnapshot(String mode, @Nullable Date targetDate) {
        this(mode, targetDate, null);
    }

    public PastSnapshot(String mode) {
        this(mode, null, null);
    }

    public PastSnapshot setIndex(int index) {
        this.index = index;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isRelatedToSnapshot() {
        return this.projectSnapshot != null;
    }

    public Snapshot getProjectSnapshot() {
        return this.projectSnapshot;
    }

    public Date getDate() {
        return this.projectSnapshot != null ? this.projectSnapshot.getCreatedAt() : null;
    }

    public PastSnapshot setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public String getModeParameter() {
        return this.modeParameter;
    }

    public PastSnapshot setModeParameter(String s) {
        this.modeParameter = s;
        return this;
    }

    Integer getProjectSnapshotId() {
        return this.projectSnapshot != null ? this.projectSnapshot.getId() : null;
    }

    public String getQualifier() {
        return this.projectSnapshot != null ? this.projectSnapshot.getQualifier() : null;
    }

    public Date getTargetDate() {
        return this.targetDate;
    }

    public String toString() {
        if (StringUtils.equals((String)this.mode, (String)"version")) {
            String label = String.format("Compare to version %s", this.modeParameter);
            if (this.getTargetDate() != null) {
                label = label + String.format(" (%s)", org.sonar.api.utils.DateUtils.formatDate((Date)this.getTargetDate()));
            }
            return label;
        }
        if (StringUtils.equals((String)this.mode, (String)"days")) {
            String label = String.format("Compare over %s days (%s", this.modeParameter, org.sonar.api.utils.DateUtils.formatDate((Date)this.getTargetDate()));
            if (this.isRelatedToSnapshot()) {
                label = label + ", analysis of " + this.getDate();
            }
            label = label + ")";
            return label;
        }
        if (StringUtils.equals((String)this.mode, (String)"previous_analysis")) {
            String label = "Compare to previous analysis";
            if (this.isRelatedToSnapshot()) {
                label = label + String.format(" (%s)", org.sonar.api.utils.DateUtils.formatDate((Date)this.getDate()));
            }
            return label;
        }
        if (StringUtils.equals((String)this.mode, (String)"previous_version")) {
            String label = "Compare to previous version";
            if (this.isRelatedToSnapshot()) {
                label = label + String.format(" (%s)", org.sonar.api.utils.DateUtils.formatDate((Date)this.getDate()));
            }
            return label;
        }
        if (StringUtils.equals((String)this.mode, (String)"date")) {
            String label = "Compare to date " + org.sonar.api.utils.DateUtils.formatDate((Date)this.getTargetDate());
            if (this.isRelatedToSnapshot()) {
                label = label + String.format(" (analysis of %s)", org.sonar.api.utils.DateUtils.formatDate((Date)this.getDate()));
            }
            return label;
        }
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

