/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sonar.api.BatchComponent;
import org.sonar.api.resources.Resource;

public class ResourceCache
implements BatchComponent {
    private final Map<String, Resource> resources = Maps.newHashMap();

    public Resource get(String componentKey) {
        return this.resources.get(componentKey);
    }

    public ResourceCache add(Resource resource) {
        String componentKey = resource.getEffectiveKey();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)componentKey) ? 1 : 0) != 0, (Object)"Missing resource effective key");
        this.resources.put(componentKey, resource);
        return this;
    }
}

