/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.profiling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.utils.TimeUtils;
import org.sonar.batch.profiling.Clock;
import org.sonar.batch.profiling.PhasesSumUpTimeProfiler;

public abstract class AbstractTimeProfiling {
    private final long startTime;
    private long totalTime;
    private Clock clock;

    public AbstractTimeProfiling(Clock clock) {
        this.clock = clock;
        this.startTime = clock.now();
    }

    public long startTime() {
        return this.startTime;
    }

    public void stop() {
        this.totalTime = this.clock.now() - this.startTime;
    }

    public long totalTime() {
        return this.totalTime;
    }

    public String totalTimeAsString() {
        return TimeUtils.formatDuration((long)this.totalTime);
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    protected void add(AbstractTimeProfiling other) {
        this.setTotalTime(this.totalTime() + other.totalTime());
    }

    static <G extends AbstractTimeProfiling> Map<Object, G> sortByDescendingTotalTime(Map<?, G> unsorted) {
        ArrayList entries = new ArrayList(unsorted.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<?, G>>(){

            @Override
            public int compare(Map.Entry<?, G> o1, Map.Entry<?, G> o2) {
                return Long.valueOf(((AbstractTimeProfiling)o2.getValue()).totalTime()).compareTo(((AbstractTimeProfiling)o1.getValue()).totalTime());
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    static <G extends AbstractTimeProfiling> List<G> truncate(Collection<G> sortedList) {
        int maxSize = 10;
        ArrayList<AbstractTimeProfiling> result = new ArrayList<AbstractTimeProfiling>(maxSize);
        int i = 0;
        for (AbstractTimeProfiling item : sortedList) {
            if (i++ >= maxSize || item.totalTime() == 0L) {
                return result;
            }
            result.add(item);
        }
        return result;
    }

    protected void println(String msg) {
        PhasesSumUpTimeProfiler.println(msg);
    }

    protected void println(String text, @Nullable Double percent, AbstractTimeProfiling phaseProfiling) {
        PhasesSumUpTimeProfiler.println(text, percent, phaseProfiling);
    }

    protected void println(String text, AbstractTimeProfiling phaseProfiling) {
        this.println(text, null, phaseProfiling);
    }
}

