/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONValue;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.BatchSettings;
import org.sonar.batch.bootstrap.ServerClient;

public class ModuleSettings
extends Settings {
    private final Configuration deprecatedCommonsConf;
    private final ServerClient client;
    private AnalysisMode analysisMode;

    public ModuleSettings(BatchSettings batchSettings, ProjectDefinition project, Configuration deprecatedCommonsConf, ServerClient client, AnalysisMode analysisMode) {
        super(batchSettings.getDefinitions());
        this.client = client;
        this.analysisMode = analysisMode;
        this.getEncryption().setPathToSecretKey(batchSettings.getString("sonar.secretKeyPath"));
        LoggerFactory.getLogger(ModuleSettings.class).info("Load module settings");
        this.deprecatedCommonsConf = deprecatedCommonsConf;
        this.init(project, batchSettings);
    }

    private ModuleSettings init(ProjectDefinition project, BatchSettings batchSettings) {
        this.addProjectProperties(project, batchSettings);
        this.addBuildProperties(project);
        this.addEnvironmentVariables();
        this.addSystemProperties();
        return this;
    }

    private void addProjectProperties(ProjectDefinition project, BatchSettings batchSettings) {
        String branch = batchSettings.getString("sonar.branch");
        String projectKey = project.getKey();
        if (StringUtils.isNotBlank((String)branch)) {
            projectKey = String.format("%s:%s", projectKey, branch);
        }
        this.addProperties(batchSettings.getProperties());
        this.downloadSettings(projectKey);
    }

    private void downloadSettings(String moduleKey) {
        String url = "/batch_bootstrap/properties?project=" + moduleKey + "&dryRun=" + this.analysisMode.isPreview();
        String jsonText = this.client.request(url);
        List json = (List)JSONValue.parse((String)jsonText);
        for (Map jsonProperty : json) {
            String key = (String)jsonProperty.get("k");
            String value = (String)jsonProperty.get("v");
            this.setProperty(key, value);
        }
    }

    private void addBuildProperties(ProjectDefinition project) {
        List<ProjectDefinition> orderedProjects = ModuleSettings.getTopDownParentProjects(project);
        for (ProjectDefinition p : orderedProjects) {
            this.addProperties(p.getProperties());
        }
    }

    static List<ProjectDefinition> getTopDownParentProjects(ProjectDefinition project) {
        ArrayList result = Lists.newArrayList();
        for (ProjectDefinition p = project; p != null; p = p.getParent()) {
            result.add(0, p);
        }
        return result;
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedCommonsConf.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedCommonsConf.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedCommonsConf.clear();
    }

    protected void doOnGetProperties(String key) {
        if (this.analysisMode.isPreview() && key.endsWith(".secured") && !key.contains(".license")) {
            throw new SonarException("Access to the secured property '" + key + "' is not possible in preview mode. The SonarQube plugin which requires this property must be deactivated in preview mode.");
        }
    }
}

