/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.report;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.api.issue.Issue;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.batch.scan.filesystem.InputFileCache;
import org.sonar.batch.scan.report.ComponentSelector;

class IncrementalComponentSelector
extends ComponentSelector {
    private final InputFileCache cache;
    private final Set<String> componentKeys = Sets.newHashSet();

    IncrementalComponentSelector(InputFileCache cache) {
        this.cache = cache;
    }

    @Override
    void init() {
        for (InputFile inputFile : this.cache.all()) {
            String componentKey;
            String status = inputFile.attribute("STATUS");
            if (status == null || "SAME".equals(status) || (componentKey = inputFile.attribute("CMP_KEY")) == null) continue;
            this.componentKeys.add(componentKey);
        }
    }

    @Override
    boolean register(Issue issue) {
        return this.componentKeys.contains(issue.componentKey());
    }

    @Override
    Set<String> componentKeys() {
        return this.componentKeys;
    }
}

