/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.batch.bootstrap.BootstrapProperties;

public class AnalysisMode
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisMode.class);
    private static final int DEFAULT_PREVIEW_READ_TIMEOUT_SEC = 60;
    private boolean preview;
    private boolean incremental;
    private int previewReadTimeoutSec;
    private boolean sensorMode;

    public AnalysisMode(BootstrapProperties bootstrapProps) {
        this.init(bootstrapProps);
    }

    public boolean isPreview() {
        return this.preview || this.incremental;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public boolean isSensorMode() {
        return this.sensorMode;
    }

    private void init(BootstrapProperties bootstrapProps) {
        if (bootstrapProps.properties().containsKey("sonar.dryRun")) {
            LOG.warn(MessageFormat.format("Property {0} is deprecated. Please use {1} instead.", "sonar.dryRun", "sonar.analysis.mode"));
            this.preview = "true".equals(bootstrapProps.property("sonar.dryRun"));
            this.incremental = false;
            this.sensorMode = false;
        } else {
            String mode = bootstrapProps.property("sonar.analysis.mode");
            this.preview = "preview".equals(mode);
            this.incremental = "incremental".equals(mode);
            this.sensorMode = "sensor".equals(mode);
        }
        if (this.incremental) {
            LOG.info("Incremental mode");
        } else if (this.preview) {
            LOG.info("Preview mode");
        } else if (this.sensorMode) {
            LOG.info("Sensor mode");
        }
        if (this.incremental || this.preview) {
            bootstrapProps.properties().put("sonar.dryRun", "true");
            this.previewReadTimeoutSec = this.loadPreviewReadTimeout(bootstrapProps);
        }
    }

    private int loadPreviewReadTimeout(BootstrapProperties bootstrapProps) {
        int readTimeoutSec;
        if (bootstrapProps.property("sonar.dryRun.readTimeout") != null) {
            LOG.warn("Property {} is deprecated. Please use {} instead.", (Object)"sonar.dryRun.readTimeout", (Object)"sonar.preview.readTimeout");
            readTimeoutSec = Integer.parseInt(bootstrapProps.property("sonar.dryRun.readTimeout"));
        } else {
            readTimeoutSec = bootstrapProps.property("sonar.preview.readTimeout") != null ? Integer.parseInt(bootstrapProps.property("sonar.preview.readTimeout")) : 60;
        }
        return readTimeoutSec;
    }

    public int getPreviewReadTimeoutSec() {
        return this.previewReadTimeoutSec;
    }
}

