/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.ClassUtils;
import org.sonar.api.batch.CheckProject;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.analyzer.Analyzer;
import org.sonar.api.batch.analyzer.AnalyzerContext;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.Project;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.scan.SensorWrapper;
import org.sonar.batch.scan2.AnalyzerOptimizer;

public class BatchExtensionDictionnary
extends org.sonar.api.batch.BatchExtensionDictionnary {
    private AnalyzerContext context;
    private AnalyzerOptimizer analyzerOptimizer;

    public BatchExtensionDictionnary(ComponentContainer componentContainer, AnalyzerContext context, AnalyzerOptimizer analyzerOptimizer) {
        super(componentContainer);
        this.context = context;
        this.analyzerOptimizer = analyzerOptimizer;
    }

    public <T> Collection<T> select(Class<T> type, @Nullable Project project, boolean sort, @Nullable ExtensionMatcher matcher) {
        List<T> result = this.getFilteredExtensions(type, project, matcher);
        if (sort) {
            return this.sort(result);
        }
        return result;
    }

    private <T> List<T> getFilteredExtensions(Class<T> type, @Nullable Project project, @Nullable ExtensionMatcher matcher) {
        ArrayList result = Lists.newArrayList();
        for (Object extension : this.getExtensions(type)) {
            if (Sensor.class.equals(type) && extension instanceof Analyzer) {
                extension = new SensorWrapper((Analyzer)extension, this.context, this.analyzerOptimizer);
            }
            if (!this.shouldKeep(type, extension, project, matcher)) continue;
            result.add(extension);
        }
        if (Sensor.class.equals(type)) {
            for (Object extension : this.getExtensions(Analyzer.class)) {
                if (!this.shouldKeep(type, extension = new SensorWrapper((Analyzer)extension, this.context, this.analyzerOptimizer), project, matcher)) continue;
                result.add(extension);
            }
        }
        return result;
    }

    private boolean shouldKeep(Class type, Object extension, @Nullable Project project, @Nullable ExtensionMatcher matcher) {
        boolean keep;
        boolean bl = keep = (ClassUtils.isAssignable(extension.getClass(), (Class)type) || Sensor.class.equals((Object)type) && ClassUtils.isAssignable(extension.getClass(), Analyzer.class)) && (matcher == null || matcher.accept(extension));
        if (keep && project != null && ClassUtils.isAssignable(extension.getClass(), CheckProject.class)) {
            keep = ((CheckProject)extension).shouldExecuteOnProject(project);
        }
        return keep;
    }
}

