/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.BootstrapProperties;
import org.sonar.batch.settings.SettingsReferential;

public class BatchSettings
extends Settings {
    private static final Logger LOG = LoggerFactory.getLogger(BatchSettings.class);
    private Configuration deprecatedConfiguration;
    private final BootstrapProperties bootstrapProps;
    private final SettingsReferential settingsReferential;
    private final AnalysisMode mode;
    private Map<String, String> savedProperties;

    public BatchSettings(BootstrapProperties bootstrapProps, PropertyDefinitions propertyDefinitions, SettingsReferential settingsReferential, Configuration deprecatedConfiguration, AnalysisMode mode) {
        super(propertyDefinitions);
        this.mode = mode;
        this.getEncryption().setPathToSecretKey(bootstrapProps.property("sonar.secretKeyPath"));
        this.bootstrapProps = bootstrapProps;
        this.settingsReferential = settingsReferential;
        this.deprecatedConfiguration = deprecatedConfiguration;
        this.init(null);
    }

    public void init(@Nullable ProjectReactor reactor) {
        this.savedProperties = this.getProperties();
        if (reactor != null) {
            LOG.info("Load project settings");
            String branch = reactor.getRoot().getProperties().getProperty("sonar.branch");
            String projectKey = reactor.getRoot().getKey();
            if (StringUtils.isNotBlank((String)branch)) {
                projectKey = String.format("%s:%s", projectKey, branch);
            }
            this.downloadSettings(projectKey);
        } else {
            LOG.info("Load global settings");
            this.downloadSettings(null);
        }
        this.addProperties(this.bootstrapProps.properties());
        if (reactor != null) {
            this.addProperties(reactor.getRoot().getProperties());
        }
    }

    public void restore() {
        this.setProperties(this.savedProperties);
    }

    private void downloadSettings(@Nullable String projectKey) {
        if (StringUtils.isNotBlank((String)projectKey)) {
            this.addProperties(this.settingsReferential.projectSettings(projectKey));
        } else {
            this.addProperties(this.settingsReferential.globalSettings());
        }
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedConfiguration.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedConfiguration.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedConfiguration.clear();
    }

    protected void doOnGetProperties(String key) {
        if (this.mode.isPreview() && key.endsWith(".secured") && !key.contains(".license")) {
            throw MessageException.of((String)("Access to the secured property '" + key + "' is not possible in preview mode. The SonarQube plugin which requires this property must be deactivated in preview mode."));
        }
    }
}

