/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.ServerMetadata;
import org.sonar.core.persistence.DatabaseVersion;
import org.sonar.core.properties.PropertiesDao;

public class DatabaseCompatibility
implements BatchComponent {
    private DatabaseVersion version;
    private Settings settings;
    private PropertiesDao propertiesDao;
    private ServerMetadata server;
    private AnalysisMode analysisMode;

    public DatabaseCompatibility(DatabaseVersion version, ServerMetadata server, Settings settings, PropertiesDao propertiesDao, AnalysisMode mode) {
        this.version = version;
        this.server = server;
        this.settings = settings;
        this.propertiesDao = propertiesDao;
        this.analysisMode = mode;
    }

    public void start() {
        if (!this.analysisMode.isPreview()) {
            this.checkCorrectServerId();
            this.checkDatabaseStatus();
        }
    }

    private void checkCorrectServerId() {
        if (!this.propertiesDao.selectGlobalProperty("sonar.core.id").getValue().equals(this.server.getServerId())) {
            StringBuilder message = new StringBuilder("The current batch process and the configured remote server do not share the same DB configuration.\n");
            message.append("\t- Batch side: ");
            message.append(this.settings.getString("sonar.jdbc.url"));
            message.append(" (");
            String userName = this.settings.getString("sonar.jdbc.username");
            message.append(userName == null ? "sonar" : userName);
            message.append(" / *****)\n\t- Server side: check the configuration at ");
            message.append(this.server.getURL());
            message.append("/system\n");
            throw MessageException.of((String)message.toString());
        }
    }

    private void checkDatabaseStatus() {
        DatabaseVersion.Status status = this.version.getStatus();
        if (status == DatabaseVersion.Status.REQUIRES_DOWNGRADE) {
            throw MessageException.of((String)"Database relates to a more recent version of SonarQube. Please check your settings (JDBC settings, version of Maven plugin)");
        }
        if (status == DatabaseVersion.Status.REQUIRES_UPGRADE) {
            throw MessageException.of((String)("Database must be upgraded. Please browse " + this.server.getURL() + "/setup"));
        }
        if (status != DatabaseVersion.Status.UP_TO_DATE) {
            throw MessageException.of((String)("Unknown database status: " + status));
        }
    }
}

