/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.home.cache.FileCache;

public class JdbcDriverHolder {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDriverHolder.class);
    private ServerClient serverClient;
    private AnalysisMode analysisMode;
    private FileCache fileCache;
    private JdbcDriverClassLoader classLoader = null;

    public JdbcDriverHolder(FileCache fileCache, AnalysisMode analysisMode, ServerClient serverClient) {
        this.serverClient = serverClient;
        this.analysisMode = analysisMode;
        this.fileCache = fileCache;
    }

    public void start() {
        if (!this.analysisMode.isPreview()) {
            try {
                LOG.info("Install JDBC driver");
                String[] nameAndHash = this.downloadJdbcDriverIndex();
                if (nameAndHash.length > 0) {
                    String filename = nameAndHash[0];
                    String hash = nameAndHash[1];
                    File jdbcDriver = this.fileCache.get(filename, hash, new FileCache.Downloader(){

                        public void download(String filename, File toFile) throws IOException {
                            String url = "/deploy/" + filename;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Download {} to {}", (Object)url, (Object)toFile.getAbsolutePath());
                            } else {
                                LOG.info("Download {}", (Object)filename);
                            }
                            JdbcDriverHolder.this.serverClient.download(url, toFile);
                        }
                    });
                    this.classLoader = JdbcDriverHolder.initClassloader(jdbcDriver);
                }
            }
            catch (SonarException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SonarException("Fail to install JDBC driver", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    JdbcDriverClassLoader getClassLoader() {
        return this.classLoader;
    }

    @VisibleForTesting
    static JdbcDriverClassLoader initClassloader(File jdbcDriver) {
        JdbcDriverClassLoader classLoader;
        try {
            ClassLoader parentClassLoader = JdbcDriverHolder.class.getClassLoader();
            classLoader = new JdbcDriverClassLoader(jdbcDriver.toURI().toURL(), parentClassLoader);
        }
        catch (MalformedURLException e) {
            throw new SonarException("Fail to get URL of : " + jdbcDriver.getAbsolutePath(), (Throwable)e);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        return classLoader;
    }

    public void stop() {
        if (this.classLoader != null) {
            this.classLoader.clearReferencesJdbc();
            if (Thread.currentThread().getContextClassLoader() == this.classLoader) {
                Thread.currentThread().setContextClassLoader(this.classLoader.getParent());
            }
            this.classLoader = null;
        }
    }

    private String[] downloadJdbcDriverIndex() {
        String url = "/deploy/jdbc-driver.txt";
        try {
            LOG.debug("Download index of jdbc-driver");
            String indexContent = this.serverClient.request(url);
            if (Strings.isNullOrEmpty((String)indexContent)) {
                return new String[0];
            }
            return indexContent.split("\\|");
        }
        catch (Exception e) {
            throw new SonarException("Fail to download jdbc-driver index: " + url, (Throwable)e);
        }
    }

    static class JdbcDriverClassLoader
    extends URLClassLoader {
        public JdbcDriverClassLoader(URL jdbcDriver, ClassLoader parent) {
            super(new URL[]{jdbcDriver}, parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearReferencesJdbc() {
            InputStream is = this.getResourceAsStream("org/sonar/batch/bootstrap/JdbcLeakPrevention.class");
            byte[] classBytes = new byte[2048];
            int offset = 0;
            try {
                int read = is.read(classBytes, offset, classBytes.length - offset);
                while (read > -1) {
                    if ((offset += read) == classBytes.length) {
                        byte[] tmp = new byte[classBytes.length * 2];
                        System.arraycopy(classBytes, 0, tmp, 0, classBytes.length);
                        classBytes = tmp;
                    }
                    read = is.read(classBytes, offset, classBytes.length - offset);
                }
                Class<?> lpClass = this.defineClass("org.sonar.batch.bootstrap.JdbcLeakPrevention", classBytes, 0, offset, this.getClass().getProtectionDomain());
                Object obj = lpClass.newInstance();
                List driverNames = (List)obj.getClass().getMethod("unregisterDrivers", new Class[0]).invoke(obj, new Object[0]);
                for (String name : driverNames) {
                    LOG.debug("To prevent a memory leak, the JDBC Driver [{}] has been forcibly deregistered", (Object)name);
                }
            }
            catch (Exception e) {
                LOG.warn("JDBC driver deregistration failed", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
        }
    }
}

