/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskComponent;
import org.sonar.api.task.TaskDefinition;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrap.BootstrapProperties;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrap.TaskProperties;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.scan.DeprecatedProjectReactorBuilder;
import org.sonar.batch.scan.ProjectReactorBuilder;
import org.sonar.batch.scan.ScanTask;
import org.sonar.batch.tasks.ListTask;
import org.sonar.batch.tasks.Tasks;
import org.sonar.core.permission.PermissionFacade;
import org.sonar.core.resource.DefaultResourcePermissions;

public class TaskContainer
extends ComponentContainer {
    private final Map<String, String> taskProperties;
    private final Object[] components;

    public TaskContainer(ComponentContainer parent, Map<String, String> taskProperties, Object ... components) {
        super(parent);
        this.taskProperties = taskProperties;
        this.components = components;
    }

    protected void doBeforeStart() {
        this.installCoreTasks();
        this.installTaskExtensions();
        this.installComponentsUsingTaskExtensions();
        for (Object component : this.components) {
            this.add(new Object[]{component});
        }
    }

    void installCoreTasks() {
        this.add(new Object[]{new TaskProperties(this.taskProperties, ((BootstrapProperties)this.getParent().getComponentByType(BootstrapProperties.class)).property("sonar.secretKeyPath"))});
        this.add(new Object[]{ScanTask.DEFINITION, ScanTask.class, ListTask.DEFINITION, ListTask.class, this.projectReactorBuilder()});
    }

    private void installTaskExtensions() {
        ((ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class)).install(this, new ExtensionMatcher(){

            @Override
            public boolean accept(Object extension) {
                return ExtensionUtils.isType(extension, TaskComponent.class);
            }
        });
    }

    private Class<?> projectReactorBuilder() {
        if (this.isRunnerVersionLessThan2Dot4()) {
            return DeprecatedProjectReactorBuilder.class;
        }
        return ProjectReactorBuilder.class;
    }

    private boolean isRunnerVersionLessThan2Dot4() {
        EnvironmentInformation env = (EnvironmentInformation)this.getComponentByType(EnvironmentInformation.class);
        return env != null && "SonarRunner".equals(env.getKey());
    }

    private void installComponentsUsingTaskExtensions() {
        this.add(new Object[]{ResourceTypes.class, PermissionFacade.class, DefaultResourcePermissions.class, Tasks.class});
    }

    public void doAfterStart() {
        String taskKey = StringUtils.defaultIfEmpty((String)this.taskProperties.get("sonar.task"), (String)"scan");
        TaskDefinition def = ((Tasks)this.getComponentByType(Tasks.class)).definition(taskKey);
        if (def == null) {
            throw MessageException.of((String)("Task " + taskKey + " does not exist"));
        }
        Task task = (Task)this.getComponentByType(def.taskClass());
        if (task == null) {
            throw new IllegalStateException("Task " + taskKey + " is badly defined");
        }
        task.execute();
    }
}

