/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.debt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.batch.components.Period;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.batch.debt.IssueChangelogDebtCalculator;

@DependsUpon(value={"END_OF_VIOLATION_TRACKING"})
public final class NewDebtDecorator
implements Decorator {
    private final ResourcePerspectives perspectives;
    private final TimeMachineConfiguration timeMachineConfiguration;
    private final IssueChangelogDebtCalculator issueChangelogDebtCalculator;

    public NewDebtDecorator(ResourcePerspectives perspectives, TimeMachineConfiguration timeMachineConfiguration, IssueChangelogDebtCalculator issueChangelogDebtCalculator) {
        this.perspectives = perspectives;
        this.timeMachineConfiguration = timeMachineConfiguration;
        this.issueChangelogDebtCalculator = issueChangelogDebtCalculator;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependedUpon
    public List<Metric> generatesMetrics() {
        return ImmutableList.of((Object)CoreMetrics.NEW_TECHNICAL_DEBT);
    }

    public void decorate(Resource resource, DecoratorContext context) {
        Issuable issuable = (Issuable)this.perspectives.as(Issuable.class, resource);
        if (issuable != null && this.shouldSaveNewMetrics(context)) {
            ArrayList issues = Lists.newArrayList((Iterable)issuable.issues());
            this.saveMeasures(context, issues);
        }
    }

    private void saveMeasures(DecoratorContext context, Collection<Issue> issues) {
        Measure measure = new Measure(CoreMetrics.NEW_TECHNICAL_DEBT);
        for (Period period : this.timeMachineConfiguration.periods()) {
            Date periodDate = period.getDate();
            double value = this.calculateNewTechnicalDebtValue(issues, periodDate);
            Collection children = context.getChildrenMeasures(measure.getMetric());
            double sum = MeasureUtils.sumOnVariation((boolean)true, (int)period.getIndex(), (Collection)children) + value;
            measure.setVariation(period.getIndex(), Double.valueOf(sum));
        }
        context.saveMeasure(measure);
    }

    private long calculateNewTechnicalDebtValue(Collection<Issue> issues, @Nullable Date periodDate) {
        long result = 0L;
        for (Issue issue : issues) {
            Long debt = this.issueChangelogDebtCalculator.calculateNewTechnicalDebt(issue, periodDate);
            if (debt == null) continue;
            result += debt.longValue();
        }
        return result;
    }

    private boolean shouldSaveNewMetrics(DecoratorContext context) {
        return context.getMeasure(CoreMetrics.NEW_TECHNICAL_DEBT) == null;
    }
}

