/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.component.Component;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.resources.Project;
import org.sonar.batch.issue.IssueCache;
import org.sonar.batch.issue.ModuleIssues;
import org.sonar.core.issue.DefaultIssueBuilder;

public class DefaultIssuable
implements Issuable {
    private final ModuleIssues moduleIssues;
    private final IssueCache cache;
    private final Component component;
    private final Project project;

    DefaultIssuable(Component component, Project project, ModuleIssues moduleIssues, IssueCache cache) {
        this.component = component;
        this.project = project;
        this.moduleIssues = moduleIssues;
        this.cache = cache;
    }

    public Issuable.IssueBuilder newIssueBuilder() {
        return new DefaultIssueBuilder().componentKey(this.component.key()).projectKey(this.project.getKey());
    }

    public boolean addIssue(Issue issue) {
        return this.moduleIssues.initAndAddIssue((DefaultIssue)issue);
    }

    public List<Issue> resolvedIssues() {
        ArrayList result = Lists.newArrayList();
        for (DefaultIssue issue : this.cache.byComponent(this.component.key())) {
            if (issue.resolution() == null) continue;
            result.add(issue);
        }
        return result;
    }

    public List<Issue> issues() {
        ArrayList result = Lists.newArrayList();
        for (DefaultIssue issue : this.cache.byComponent(this.component.key())) {
            if (issue.resolution() != null) continue;
            result.add(issue);
        }
        return result;
    }

    public Component component() {
        return this.component;
    }
}

