/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.config.Settings;
import org.sonar.batch.issue.ignore.pattern.IssuePattern;
import org.sonar.batch.issue.ignore.pattern.PatternDecoder;

public abstract class AbstractPatternInitializer
implements BatchExtension {
    private Settings settings;
    private List<IssuePattern> multicriteriaPatterns;

    protected AbstractPatternInitializer(Settings settings) {
        this.settings = settings;
        this.initPatterns();
    }

    protected Settings getSettings() {
        return this.settings;
    }

    public List<IssuePattern> getMulticriteriaPatterns() {
        return this.multicriteriaPatterns;
    }

    public boolean hasConfiguredPatterns() {
        return this.hasMulticriteriaPatterns();
    }

    public boolean hasMulticriteriaPatterns() {
        return !this.multicriteriaPatterns.isEmpty();
    }

    public abstract void initializePatternsForPath(String var1, String var2);

    @VisibleForTesting
    protected final void initPatterns() {
        this.multicriteriaPatterns = Lists.newArrayList();
        String patternConf = StringUtils.defaultIfBlank((String)this.settings.getString(this.getMulticriteriaConfigurationKey()), (String)"");
        for (String id : StringUtils.split((String)patternConf, (char)',')) {
            String propPrefix = this.getMulticriteriaConfigurationKey() + "." + id + ".";
            String resourceKeyPattern = this.settings.getString(propPrefix + "resourceKey");
            String ruleKeyPattern = this.settings.getString(propPrefix + "ruleKey");
            String lineRange = "*";
            Object[] fields = new String[]{resourceKeyPattern, ruleKeyPattern, lineRange};
            PatternDecoder.checkRegularLineConstraints(StringUtils.join((Object[])fields, (String)","), (String[])fields);
            IssuePattern pattern = new IssuePattern((String)Objects.firstNonNull((Object)resourceKeyPattern, (Object)"*"), (String)Objects.firstNonNull((Object)ruleKeyPattern, (Object)"*"));
            PatternDecoder.decodeRangeOfLines(pattern, (String)Objects.firstNonNull((Object)lineRange, (Object)"*"));
            this.multicriteriaPatterns.add(pattern);
        }
    }

    protected abstract String getMulticriteriaConfigurationKey();
}

