/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.issue.ignore.pattern.IssuePattern;

public class PatternDecoder {
    private static final int THREE_FIELDS_PER_LINE = 3;
    private static final String LINE_RANGE_REGEXP = "\\[((\\d+|\\d+-\\d+),?)*\\]";
    private static final String CONFIG_FORMAT_ERROR_PREFIX = "Exclusions > Issues : Invalid format. ";

    public List<IssuePattern> decode(String patternsList) {
        String[] patternsLines;
        LinkedList patterns = Lists.newLinkedList();
        for (String patternLine : patternsLines = StringUtils.split((String)patternsList, (String)"\n")) {
            IssuePattern pattern = this.decodeLine(patternLine.trim());
            if (pattern == null) continue;
            patterns.add(pattern);
        }
        return patterns;
    }

    public IssuePattern decodeLine(String line) {
        IssuePattern pattern;
        if (PatternDecoder.isBlankOrComment(line)) {
            return null;
        }
        String[] fields = StringUtils.splitPreserveAllTokens((String)line, (char)';');
        if (fields.length > 3) {
            throw new SonarException("Exclusions > Issues : Invalid format. The following line has more than 3 fields separated by comma: " + line);
        }
        if (fields.length == 3) {
            PatternDecoder.checkRegularLineConstraints(line, fields);
            pattern = new IssuePattern(StringUtils.trim((String)fields[0]), StringUtils.trim((String)fields[1]));
            PatternDecoder.decodeRangeOfLines(pattern, fields[2]);
        } else if (fields.length == 2) {
            PatternDecoder.checkDoubleRegexpLineConstraints(line, fields);
            pattern = new IssuePattern().setBeginBlockRegexp(fields[0]).setEndBlockRegexp(fields[1]);
        } else {
            PatternDecoder.checkWholeFileRegexp(fields[0]);
            pattern = new IssuePattern().setAllFileRegexp(fields[0]);
        }
        return pattern;
    }

    static void checkRegularLineConstraints(String line, String[] fields) {
        if (!PatternDecoder.isResource(fields[0])) {
            throw new SonarException("Exclusions > Issues : Invalid format. The first field does not define a resource pattern: " + line);
        }
        if (!PatternDecoder.isRule(fields[1])) {
            throw new SonarException("Exclusions > Issues : Invalid format. The second field does not define a rule pattern: " + line);
        }
        if (!PatternDecoder.isLinesRange(fields[2])) {
            throw new SonarException("Exclusions > Issues : Invalid format. The third field does not define a range of lines: " + line);
        }
    }

    static void checkDoubleRegexpLineConstraints(String line, String[] fields) {
        if (!PatternDecoder.isRegexp(fields[0])) {
            throw new SonarException("Exclusions > Issues : Invalid format. The first field does not define a regular expression: " + line);
        }
    }

    static void checkWholeFileRegexp(String regexp) {
        if (!PatternDecoder.isRegexp(regexp)) {
            throw new SonarException("Exclusions > Issues : Invalid format. The field does not define a regular expression: " + regexp);
        }
    }

    public static void decodeRangeOfLines(IssuePattern pattern, String field) {
        if (StringUtils.equals((String)field, (String)"*")) {
            pattern.setCheckLines(false);
        } else {
            String[] parts;
            pattern.setCheckLines(true);
            String s = StringUtils.substringBetween((String)StringUtils.trim((String)field), (String)"[", (String)"]");
            for (String part : parts = StringUtils.split((String)s, (char)',')) {
                if (StringUtils.contains((String)part, (char)'-')) {
                    String[] range = StringUtils.split((String)part, (char)'-');
                    pattern.addLineRange(Integer.valueOf(range[0]), Integer.valueOf(range[1]));
                    continue;
                }
                pattern.addLine(Integer.valueOf(part));
            }
        }
    }

    @VisibleForTesting
    static boolean isLinesRange(String field) {
        return StringUtils.equals((String)field, (String)"*") || Pattern.matches(LINE_RANGE_REGEXP, field);
    }

    @VisibleForTesting
    static boolean isBlankOrComment(String line) {
        return StringUtils.isBlank((String)line) ^ StringUtils.startsWith((String)line, (String)"#");
    }

    @VisibleForTesting
    static boolean isResource(String field) {
        return StringUtils.isNotBlank((String)field);
    }

    @VisibleForTesting
    static boolean isRule(String field) {
        return StringUtils.isNotBlank((String)field);
    }

    @VisibleForTesting
    static boolean isRegexp(String field) {
        return StringUtils.isNotBlank((String)field);
    }
}

