/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore.pattern;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.sonar.api.issue.Issue;
import org.sonar.batch.issue.ignore.pattern.IssuePattern;
import org.sonar.batch.issue.ignore.pattern.LineRange;

public class PatternMatcher {
    private Multimap<String, IssuePattern> patternByComponent = LinkedHashMultimap.create();

    public IssuePattern getMatchingPattern(Issue issue) {
        IssuePattern matchingPattern = null;
        Iterator<IssuePattern> patternIterator = this.getPatternsForComponent(issue.componentKey()).iterator();
        while (matchingPattern == null && patternIterator.hasNext()) {
            IssuePattern nextPattern = patternIterator.next();
            if (!nextPattern.match(issue)) continue;
            matchingPattern = nextPattern;
        }
        return matchingPattern;
    }

    public Collection<IssuePattern> getPatternsForComponent(String componentKey) {
        return this.patternByComponent.get((Object)componentKey);
    }

    public void addPatternForComponent(String component, IssuePattern pattern) {
        this.patternByComponent.put((Object)component, (Object)pattern.forResource(component));
    }

    public void addPatternToExcludeResource(String resource) {
        this.addPatternForComponent(resource, new IssuePattern(resource, "*").setCheckLines(false));
    }

    public void addPatternToExcludeLines(String resource, Set<LineRange> lineRanges) {
        this.addPatternForComponent(resource, new IssuePattern(resource, "*", lineRanges).setCheckLines(true));
    }
}

