/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue.ignore.scanner;

import java.nio.charset.Charset;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.issue.ignore.pattern.IssueExclusionPatternInitializer;
import org.sonar.batch.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.batch.issue.ignore.scanner.IssueExclusionsRegexpScanner;

public final class IssueExclusionsLoader {
    private final IssueExclusionsRegexpScanner regexpScanner;
    private final IssueExclusionPatternInitializer exclusionPatternInitializer;
    private final IssueInclusionPatternInitializer inclusionPatternInitializer;
    private final FileSystem fileSystem;

    public IssueExclusionsLoader(IssueExclusionsRegexpScanner regexpScanner, IssueExclusionPatternInitializer exclusionPatternInitializer, IssueInclusionPatternInitializer inclusionPatternInitializer, FileSystem fileSystem) {
        this.regexpScanner = regexpScanner;
        this.exclusionPatternInitializer = exclusionPatternInitializer;
        this.inclusionPatternInitializer = inclusionPatternInitializer;
        this.fileSystem = fileSystem;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.inclusionPatternInitializer.hasConfiguredPatterns() || this.exclusionPatternInitializer.hasConfiguredPatterns();
    }

    public void execute() {
        Charset sourcesEncoding = this.fileSystem.encoding();
        for (InputFile inputFile : this.fileSystem.inputFiles(this.fileSystem.predicates().all())) {
            try {
                String componentEffectiveKey = ((DeprecatedDefaultInputFile)inputFile).key();
                if (componentEffectiveKey == null) continue;
                String path = inputFile.relativePath();
                this.inclusionPatternInitializer.initializePatternsForPath(path, componentEffectiveKey);
                this.exclusionPatternInitializer.initializePatternsForPath(path, componentEffectiveKey);
                if (!this.exclusionPatternInitializer.hasFileContentPattern()) continue;
                this.regexpScanner.scan(componentEffectiveKey, inputFile.file(), sourcesEncoding);
            }
            catch (Exception e) {
                throw new SonarException("Unable to read the source file : '" + inputFile.absolutePath() + "' with the charset : '" + sourcesEncoding.name() + "'.", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "Issues Exclusions - Source Scanner";
    }
}

