/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.maven;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;

@SupportedEnvironment(value={"maven"})
public class MavenProjectBuilder
extends ProjectBuilder {
    private final MavenSession mavenSession;

    public MavenProjectBuilder(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public void build(ProjectBuilder.Context context) {
        ProjectReactor reactor = context.projectReactor();
        for (ProjectDefinition moduleDef : reactor.getProjects()) {
            this.setMavenProjectIfApplicable(moduleDef);
        }
    }

    private void setMavenProjectIfApplicable(ProjectDefinition definition) {
        if (this.mavenSession != null) {
            String moduleKey = definition.getKey();
            for (MavenProject mavenModule : this.mavenSession.getSortedProjects()) {
                String mavenModuleKey = mavenModule.getGroupId() + ":" + mavenModule.getArtifactId();
                if (!mavenModuleKey.equals(moduleKey) || definition.getContainerExtensions().contains(mavenModule)) continue;
                definition.addContainerExtension((Object)mavenModule);
            }
        }
    }
}

