/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.qualitygate;

import com.google.gson.JsonObject;
import javax.annotation.CheckForNull;
import org.sonar.api.measures.Metric;

public class ResolvedCondition {
    private static final String ATTRIBUTE_PERIOD = "period";
    private static final String ATTRIBUTE_ERROR = "error";
    private static final String ATTRIBUTE_WARNING = "warning";
    private JsonObject json;
    private Metric metric;

    public ResolvedCondition(JsonObject jsonObject, Metric metric) {
        this.json = jsonObject;
        this.metric = metric;
    }

    public Long id() {
        return this.json.get("id").getAsLong();
    }

    public String metricKey() {
        return this.json.get("metric").getAsString();
    }

    public Metric metric() {
        return this.metric;
    }

    public String operator() {
        return this.json.get("op").getAsString();
    }

    @CheckForNull
    public String warningThreshold() {
        return this.json.has(ATTRIBUTE_WARNING) ? this.json.get(ATTRIBUTE_WARNING).getAsString() : null;
    }

    @CheckForNull
    public String errorThreshold() {
        return this.json.has(ATTRIBUTE_ERROR) ? this.json.get(ATTRIBUTE_ERROR).getAsString() : null;
    }

    @CheckForNull
    public Integer period() {
        return this.json.has(ATTRIBUTE_PERIOD) ? Integer.valueOf(this.json.get(ATTRIBUTE_PERIOD).getAsInt()) : null;
    }
}

