/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import com.google.common.collect.ArrayListMultimap;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleParam;
import org.sonar.batch.rule.ModuleQProfiles;
import org.sonar.batch.rule.QProfile;
import org.sonar.core.qualityprofile.db.ActiveRuleDao;
import org.sonar.core.qualityprofile.db.ActiveRuleDto;
import org.sonar.core.qualityprofile.db.ActiveRuleParamDto;

public class ActiveRulesProvider
extends ProviderAdapter {
    private ActiveRules singleton = null;

    public ActiveRules provide(ModuleQProfiles qProfiles, ActiveRuleDao dao, RuleFinder ruleFinder) {
        if (this.singleton == null) {
            this.singleton = this.load(qProfiles, dao, ruleFinder);
        }
        return this.singleton;
    }

    private ActiveRules load(ModuleQProfiles qProfiles, ActiveRuleDao dao, RuleFinder ruleFinder) {
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        for (QProfile qProfile : qProfiles.findAll()) {
            ArrayListMultimap paramDtosByActiveRuleId = ArrayListMultimap.create();
            for (ActiveRuleParamDto dto : dao.selectParamsByProfileKey(qProfile.getKey())) {
                paramDtosByActiveRuleId.put((Object)dto.getActiveRuleId(), (Object)dto);
            }
            for (ActiveRuleDto activeDto : dao.selectByProfileKey(qProfile.getKey())) {
                Rule rule = ruleFinder.findById(activeDto.getRulId().intValue());
                if (rule == null) continue;
                NewActiveRule newActiveRule = builder.create(rule.ruleKey());
                newActiveRule.setSeverity(activeDto.getSeverityString());
                newActiveRule.setLanguage(rule.getLanguage());
                Rule template = rule.getTemplate();
                if (template != null) {
                    newActiveRule.setInternalKey(template.getConfigKey());
                } else {
                    newActiveRule.setInternalKey(rule.getConfigKey());
                }
                for (ActiveRuleParamDto paramDto : paramDtosByActiveRuleId.get((Object)activeDto.getId())) {
                    newActiveRule.setParam(paramDto.getKey(), paramDto.getValue());
                }
                for (RuleParam param : rule.getParams()) {
                    if (newActiveRule.params().containsKey(param.getKey())) continue;
                    newActiveRule.setParam(param.getKey(), param.getDefaultValue());
                }
                newActiveRule.activate();
            }
        }
        return builder.build();
    }
}

