/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.Settings;
import org.sonar.api.task.TaskComponent;
import org.sonar.batch.scan.ProjectSettingsReady;

public class ProjectExclusions
implements TaskComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectExclusions.class);
    private Settings settings;
    private ProjectReactor reactor;

    public ProjectExclusions(Settings settings, ProjectReactor reactor, ProjectSettingsReady settingsReady, @Nullable ProjectBuilder[] projectBuilders) {
        this.settings = settings;
        this.reactor = reactor;
    }

    public ProjectExclusions(Settings settings, ProjectReactor reactor, ProjectSettingsReady settingsReady) {
        this(settings, reactor, settingsReady, new ProjectBuilder[0]);
    }

    public void apply() {
        if (!this.reactor.getProjects().isEmpty() && StringUtils.isNotBlank((String)((ProjectDefinition)this.reactor.getProjects().get(0)).getKey())) {
            LOG.info("Apply project exclusions");
            if (this.settings.hasKey("sonar.includedModules")) {
                LOG.warn("'sonar.includedModules' property is deprecated since version 4.3 and should not be used anymore.");
            }
            if (this.settings.hasKey("sonar.skippedModules")) {
                LOG.warn("'sonar.skippedModules' property is deprecated since version 4.3 and should not be used anymore.");
            }
            for (ProjectDefinition project : this.reactor.getProjects()) {
                if (!this.isExcluded(ProjectExclusions.key(project), project == this.reactor.getRoot())) continue;
                this.exclude(project);
            }
        }
    }

    private boolean isExcluded(String projectKey, boolean isRoot) {
        Object[] includedKeys = this.settings.getStringArray("sonar.includedModules");
        boolean excluded = false;
        if (!isRoot && includedKeys.length > 0) {
            excluded = !ArrayUtils.contains((Object[])includedKeys, (Object)projectKey);
        }
        String skippedModulesProperty = "sonar.skippedModules";
        if (!excluded) {
            Object[] excludedKeys = this.settings.getStringArray(skippedModulesProperty);
            excluded = ArrayUtils.contains((Object[])excludedKeys, (Object)projectKey);
        }
        if (excluded && isRoot) {
            throw new IllegalArgumentException("The root project can't be excluded. Please check the parameters " + skippedModulesProperty + " and sonar.includedModules.");
        }
        return excluded;
    }

    private void exclude(ProjectDefinition project) {
        LOG.info(String.format("Exclude project: %s [%s]", project.getName(), project.getKey()));
        project.remove();
    }

    static String key(ProjectDefinition project) {
        String key = project.getKey();
        if (key.contains(":")) {
            return StringUtils.substringAfter((String)key, (String)":");
        }
        return key;
    }
}

