/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.bootstrap.TaskProperties;

public class ProjectReactorBuilder {
    private static final String INVALID_VALUE_OF_X_FOR_Y = "Invalid value of {0} for {1}";
    private static final Logger LOG = LoggerFactory.getLogger(ProjectReactorBuilder.class);
    private static final String MODULE_KEY_PROPERTY = "sonar.moduleKey";
    protected static final String PROPERTY_PROJECT_BASEDIR = "sonar.projectBaseDir";
    private static final String PROPERTY_PROJECT_BUILDDIR = "sonar.projectBuildDir";
    private static final String PROPERTY_MODULES = "sonar.modules";
    private static final String PROPERTY_SOURCES = "sonar.sources";
    private static final String PROPERTY_TESTS = "sonar.tests";
    private static final String PROPERTY_BINARIES = "sonar.binaries";
    private static final String PROPERTY_LIBRARIES = "sonar.libraries";
    private static final String[] MANDATORY_PROPERTIES_FOR_SIMPLE_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey", "sonar.projectName", "sonar.projectVersion", "sonar.sources"};
    private static final String[] MANDATORY_PROPERTIES_FOR_MULTIMODULE_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey", "sonar.projectName", "sonar.projectVersion"};
    protected static final String[] MANDATORY_PROPERTIES_FOR_CHILD = new String[]{"sonar.moduleKey", "sonar.projectName"};
    private static final List<String> NON_HERITED_PROPERTIES_FOR_CHILD = Lists.newArrayList((Object[])new String[]{"sonar.projectBaseDir", "sonar.working.directory", "sonar.modules", "sonar.projectDescription"});
    private TaskProperties props;
    private File rootProjectWorkDir;

    public ProjectReactorBuilder(TaskProperties props) {
        this.props = props;
    }

    public ProjectReactor execute() {
        Properties bootstrapProperties = new Properties();
        bootstrapProperties.putAll(this.props.properties());
        ProjectDefinition rootProject = this.defineProject(bootstrapProperties, null);
        this.rootProjectWorkDir = rootProject.getWorkDir();
        this.defineChildren(rootProject);
        ProjectReactorBuilder.cleanAndCheckProjectDefinitions(rootProject);
        return new ProjectReactor(rootProject);
    }

    protected ProjectDefinition defineProject(Properties properties, @Nullable ProjectDefinition parent) {
        File workDir;
        if (properties.containsKey(PROPERTY_MODULES)) {
            ProjectReactorBuilder.checkMandatoryProperties(properties, MANDATORY_PROPERTIES_FOR_MULTIMODULE_PROJECT);
        } else {
            ProjectReactorBuilder.checkMandatoryProperties(properties, MANDATORY_PROPERTIES_FOR_SIMPLE_PROJECT);
        }
        File baseDir = new File(properties.getProperty(PROPERTY_PROJECT_BASEDIR));
        String projectKey = properties.getProperty("sonar.projectKey");
        if (parent == null) {
            ProjectReactorBuilder.validateDirectories(properties, baseDir, projectKey);
            workDir = this.initRootProjectWorkDir(baseDir);
        } else {
            workDir = this.initModuleWorkDir(baseDir, properties);
        }
        return ProjectDefinition.create().setProperties(properties).setBaseDir(baseDir).setWorkDir(workDir).setBuildDir(this.initModuleBuildDir(baseDir, properties));
    }

    @VisibleForTesting
    protected File initRootProjectWorkDir(File baseDir) {
        String workDir = this.props.property("sonar.working.directory");
        if (StringUtils.isBlank((String)workDir)) {
            return new File(baseDir, ".sonar");
        }
        File customWorkDir = new File(workDir);
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(baseDir, customWorkDir.getPath());
    }

    @VisibleForTesting
    protected File initModuleWorkDir(File moduleBaseDir, Properties moduleProperties) {
        String workDir = moduleProperties.getProperty("sonar.working.directory");
        if (StringUtils.isBlank((String)workDir)) {
            String cleanKey = StringUtils.deleteWhitespace((String)moduleProperties.getProperty("sonar.projectKey"));
            cleanKey = StringUtils.replace((String)cleanKey, (String)":", (String)"_");
            return new File(this.rootProjectWorkDir, cleanKey);
        }
        File customWorkDir = new File(workDir);
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(moduleBaseDir, customWorkDir.getPath());
    }

    @CheckForNull
    private File initModuleBuildDir(File moduleBaseDir, Properties moduleProperties) {
        String buildDir = moduleProperties.getProperty(PROPERTY_PROJECT_BUILDDIR);
        if (StringUtils.isBlank((String)buildDir)) {
            return null;
        }
        File customBuildDir = new File(buildDir);
        if (customBuildDir.isAbsolute()) {
            return customBuildDir;
        }
        return new File(moduleBaseDir, customBuildDir.getPath());
    }

    private void defineChildren(ProjectDefinition parentProject) {
        Properties parentProps = parentProject.getProperties();
        if (parentProps.containsKey(PROPERTY_MODULES)) {
            for (String module : ProjectReactorBuilder.getListFromProperty(parentProps, PROPERTY_MODULES)) {
                Properties moduleProps = ProjectReactorBuilder.extractModuleProperties(module, parentProps);
                ProjectDefinition childProject = this.loadChildProject(parentProject, moduleProps, module);
                ProjectReactorBuilder.checkUniquenessOfChildKey(childProject, parentProject);
                this.defineChildren(childProject);
                parentProject.addSubProject(childProject);
            }
        }
    }

    protected ProjectDefinition loadChildProject(ProjectDefinition parentProject, Properties moduleProps, String moduleId) {
        File baseDir;
        if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            baseDir = ProjectReactorBuilder.resolvePath(parentProject.getBaseDir(), moduleProps.getProperty(PROPERTY_PROJECT_BASEDIR));
            ProjectReactorBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
        } else {
            baseDir = new File(parentProject.getBaseDir(), moduleId);
            ProjectReactorBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
        }
        ProjectReactorBuilder.setModuleKeyAndNameIfNotDefined(moduleProps, moduleId, parentProject.getKey());
        ProjectReactorBuilder.checkMandatoryProperties(moduleProps, MANDATORY_PROPERTIES_FOR_CHILD);
        ProjectReactorBuilder.validateDirectories(moduleProps, baseDir, moduleId);
        ProjectReactorBuilder.mergeParentProperties(moduleProps, parentProject.getProperties());
        return this.defineProject(moduleProps, parentProject);
    }

    @VisibleForTesting
    protected static Properties toProperties(File propertyFile) {
        Properties propsFromFile = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(propertyFile);
            propsFromFile.load(fileInputStream);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Impossible to read the property file: " + propertyFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        for (String propKey : propsFromFile.stringPropertyNames()) {
            propsFromFile.setProperty(propKey, StringUtils.trim((String)propsFromFile.getProperty(propKey)));
        }
        return propsFromFile;
    }

    @VisibleForTesting
    protected static void setModuleKeyAndNameIfNotDefined(Properties childProps, String moduleId, String parentKey) {
        if (!childProps.containsKey(MODULE_KEY_PROPERTY)) {
            if (!childProps.containsKey("sonar.projectKey")) {
                childProps.put(MODULE_KEY_PROPERTY, parentKey + ":" + moduleId);
            } else {
                String childKey = childProps.getProperty("sonar.projectKey");
                childProps.put(MODULE_KEY_PROPERTY, parentKey + ":" + childKey);
            }
        }
        if (!childProps.containsKey("sonar.projectName")) {
            childProps.put("sonar.projectName", moduleId);
        }
        childProps.put("sonar.projectKey", childProps.getProperty(MODULE_KEY_PROPERTY));
    }

    @VisibleForTesting
    protected static void checkUniquenessOfChildKey(ProjectDefinition childProject, ProjectDefinition parentProject) {
        for (ProjectDefinition definition : parentProject.getSubProjects()) {
            if (!definition.getKey().equals(childProject.getKey())) continue;
            throw new IllegalStateException("Project '" + parentProject.getKey() + "' can't have 2 modules with the following key: " + childProject.getKey());
        }
    }

    protected static void setProjectBaseDir(File baseDir, Properties childProps, String moduleId) {
        if (!baseDir.isDirectory()) {
            throw new IllegalStateException("The base directory of the module '" + moduleId + "' does not exist: " + baseDir.getAbsolutePath());
        }
        childProps.put(PROPERTY_PROJECT_BASEDIR, baseDir.getAbsolutePath());
    }

    @VisibleForTesting
    protected static void checkMandatoryProperties(Properties props, String[] mandatoryProps) {
        StringBuilder missing = new StringBuilder();
        for (String mandatoryProperty : mandatoryProps) {
            if (props.containsKey(mandatoryProperty)) continue;
            if (missing.length() > 0) {
                missing.append(", ");
            }
            missing.append(mandatoryProperty);
        }
        String moduleKey = StringUtils.defaultIfBlank((String)props.getProperty(MODULE_KEY_PROPERTY), (String)props.getProperty("sonar.projectKey"));
        if (missing.length() != 0) {
            throw new IllegalStateException("You must define the following mandatory properties for '" + (moduleKey == null ? "Unknown" : moduleKey) + "': " + missing);
        }
    }

    protected static void validateDirectories(Properties props, File baseDir, String projectId) {
        if (!props.containsKey(PROPERTY_MODULES)) {
            for (String pattern : ProjectReactorBuilder.getListFromProperty(props, PROPERTY_LIBRARIES)) {
                File[] files = ProjectReactorBuilder.getLibraries(baseDir, pattern);
                if (files != null && files.length != 0) continue;
                LOG.error(MessageFormat.format(INVALID_VALUE_OF_X_FOR_Y, PROPERTY_LIBRARIES, projectId));
                throw new IllegalStateException("No files nor directories matching '" + pattern + "' in directory " + baseDir);
            }
            String[] testDirs = ProjectReactorBuilder.getListFromProperty(props, PROPERTY_TESTS);
            ProjectReactorBuilder.checkExistenceOfDirectories(projectId, baseDir, testDirs, PROPERTY_TESTS);
            String[] binDirs = ProjectReactorBuilder.getListFromProperty(props, PROPERTY_BINARIES);
            ProjectReactorBuilder.checkExistenceOfDirectories(projectId, baseDir, binDirs, PROPERTY_BINARIES);
        }
    }

    @VisibleForTesting
    protected static void cleanAndCheckProjectDefinitions(ProjectDefinition project) {
        if (project.getSubProjects().isEmpty()) {
            ProjectReactorBuilder.cleanAndCheckModuleProperties(project);
        } else {
            ProjectReactorBuilder.cleanAndCheckAggregatorProjectProperties(project);
            for (ProjectDefinition module : project.getSubProjects()) {
                ProjectReactorBuilder.cleanAndCheckProjectDefinitions(module);
            }
        }
    }

    @VisibleForTesting
    protected static void cleanAndCheckModuleProperties(ProjectDefinition project) {
        Properties properties = project.getProperties();
        String[] sourceDirs = ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_SOURCES);
        ProjectReactorBuilder.checkExistenceOfDirectories(project.getKey(), project.getBaseDir(), sourceDirs, PROPERTY_SOURCES);
        ArrayList libPaths = Lists.newArrayList();
        for (String pattern : ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_LIBRARIES)) {
            for (File file : ProjectReactorBuilder.getLibraries(project.getBaseDir(), pattern)) {
                libPaths.add(file.getAbsolutePath());
            }
        }
        properties.remove(PROPERTY_LIBRARIES);
        properties.put(PROPERTY_LIBRARIES, StringUtils.join((Collection)libPaths, (String)","));
    }

    @VisibleForTesting
    protected static void cleanAndCheckAggregatorProjectProperties(ProjectDefinition project) {
        String[] sourceDirs;
        Properties properties = project.getProperties();
        for (String path : sourceDirs = ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_SOURCES)) {
            File sourceFolder = ProjectReactorBuilder.resolvePath(project.getBaseDir(), path);
            if (!sourceFolder.isDirectory()) continue;
            LOG.warn("/!\\ A multi-module project can't have source folders, so '{}' won't be used for the analysis. If you want to analyse files of this folder, you should create another sub-module and move them inside it.", (Object)sourceFolder.toString());
        }
        properties.remove(PROPERTY_SOURCES);
        properties.remove(PROPERTY_TESTS);
        properties.remove(PROPERTY_BINARIES);
        properties.remove(PROPERTY_LIBRARIES);
        Properties clone = (Properties)properties.clone();
        ArrayList moduleIds = Lists.newArrayList((Object[])ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_MODULES));
        for (Map.Entry<Object, Object> entry : clone.entrySet()) {
            String key = (String)entry.getKey();
            if (!ProjectReactorBuilder.isKeyPrefixedByModuleId(key, moduleIds)) continue;
            properties.remove(key);
        }
    }

    @VisibleForTesting
    protected static void mergeParentProperties(Properties childProps, Properties parentProps) {
        ArrayList moduleIds = Lists.newArrayList((Object[])ProjectReactorBuilder.getListFromProperty(parentProps, PROPERTY_MODULES));
        for (Map.Entry<Object, Object> entry : parentProps.entrySet()) {
            String key = (String)entry.getKey();
            if (childProps.containsKey(key) || NON_HERITED_PROPERTIES_FOR_CHILD.contains(key) || ProjectReactorBuilder.isKeyPrefixedByModuleId(key, moduleIds)) continue;
            childProps.put(entry.getKey(), entry.getValue());
        }
    }

    private static boolean isKeyPrefixedByModuleId(String key, List<String> moduleIds) {
        for (String moduleId : moduleIds) {
            if (!key.startsWith(moduleId + ".")) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected static Properties extractModuleProperties(String module, Properties properties) {
        Properties moduleProps = new Properties();
        String propertyPrefix = module + ".";
        int prefixLength = propertyPrefix.length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(propertyPrefix)) continue;
            moduleProps.put(key.substring(prefixLength), entry.getValue());
        }
        return moduleProps;
    }

    @VisibleForTesting
    protected static void checkExistenceOfDirectories(String moduleRef, File baseDir, String[] sourceDirs, String propName) {
        for (String path : sourceDirs) {
            File sourceFolder = ProjectReactorBuilder.resolvePath(baseDir, path);
            if (sourceFolder.isDirectory()) continue;
            LOG.error(MessageFormat.format(INVALID_VALUE_OF_X_FOR_Y, propName, moduleRef));
            throw new IllegalStateException("The folder '" + path + "' does not exist for '" + moduleRef + "' (base directory = " + baseDir.getAbsolutePath() + ")");
        }
    }

    @VisibleForTesting
    protected static File[] getLibraries(File baseDir, String pattern) {
        String filePattern;
        String dirPath;
        int i = Math.max(pattern.lastIndexOf(47), pattern.lastIndexOf(92));
        if (i == -1) {
            dirPath = ".";
            filePattern = pattern;
        } else {
            dirPath = pattern.substring(0, i);
            filePattern = pattern.substring(i + 1);
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        if (pattern.indexOf(42) >= 0) {
            filters.add(FileFileFilter.FILE);
        }
        filters.add(new WildcardFileFilter(filePattern));
        File dir = ProjectReactorBuilder.resolvePath(baseDir, dirPath);
        File[] files = dir.listFiles((FileFilter)new AndFileFilter(filters));
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    protected static File resolvePath(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(baseDir, path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to resolve path \"" + path + "\"", e);
            }
        }
        return file;
    }

    static String[] getListFromProperty(Properties properties, String key) {
        return StringUtils.stripAll((String[])StringUtils.split((String)properties.getProperty(key, ""), (char)','));
    }
}

