/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.scan.filesystem.FileExclusions;

public class ExclusionFilters
implements BatchComponent {
    private final FileExclusions exclusionSettings;
    private PathPattern[] mainInclusions;
    private PathPattern[] mainExclusions;
    private PathPattern[] testInclusions;
    private PathPattern[] testExclusions;

    public ExclusionFilters(FileExclusions exclusions) {
        this.exclusionSettings = exclusions;
    }

    public void prepare() {
        this.mainInclusions = this.prepareMainInclusions();
        this.mainExclusions = this.prepareMainExclusions();
        this.testInclusions = this.prepareTestInclusions();
        this.testExclusions = this.prepareTestExclusions();
        this.log("Included sources: ", this.mainInclusions);
        this.log("Excluded sources: ", this.mainExclusions);
        this.log("Included tests: ", this.testInclusions);
        this.log("Excluded tests: ", this.testExclusions);
    }

    private void log(String title, PathPattern[] patterns) {
        if (patterns.length > 0) {
            Logger log = LoggerFactory.getLogger(ExclusionFilters.class);
            log.info(title);
            for (PathPattern pattern : patterns) {
                log.info("  " + pattern);
            }
        }
    }

    public boolean accept(InputFile inputFile, InputFile.Type type) {
        PathPattern[] exclusionPatterns;
        PathPattern[] inclusionPatterns;
        if (InputFile.Type.MAIN == type) {
            inclusionPatterns = this.mainInclusions;
            exclusionPatterns = this.mainExclusions;
        } else if (InputFile.Type.TEST == type) {
            inclusionPatterns = this.testInclusions;
            exclusionPatterns = this.testExclusions;
        } else {
            throw new IllegalArgumentException("Unknown file type: " + type);
        }
        if (inclusionPatterns.length > 0) {
            boolean matchInclusion = false;
            for (PathPattern pattern : inclusionPatterns) {
                matchInclusion |= pattern.match(inputFile);
            }
            if (!matchInclusion) {
                return false;
            }
        }
        if (exclusionPatterns.length > 0) {
            for (PathPattern pattern : exclusionPatterns) {
                if (!pattern.match(inputFile)) continue;
                return false;
            }
        }
        return true;
    }

    PathPattern[] prepareMainInclusions() {
        if (this.exclusionSettings.sourceInclusions().length > 0) {
            return PathPattern.create((String[])this.exclusionSettings.sourceInclusions());
        }
        return new PathPattern[0];
    }

    PathPattern[] prepareTestInclusions() {
        return PathPattern.create((String[])this.computeTestInclusions());
    }

    private String[] computeTestInclusions() {
        if (this.exclusionSettings.testInclusions().length > 0) {
            return this.exclusionSettings.testInclusions();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    PathPattern[] prepareMainExclusions() {
        String[] patterns = (String[])ArrayUtils.addAll((Object[])this.exclusionSettings.sourceExclusions(), (Object[])this.computeTestInclusions());
        return PathPattern.create((String[])patterns);
    }

    PathPattern[] prepareTestExclusions() {
        return PathPattern.create((String[])this.exclusionSettings.testExclusions());
    }
}

