/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.ExclusionFilters;
import org.sonar.batch.scan.filesystem.InputFileBuilder;
import org.sonar.batch.scan.filesystem.InputFileBuilderFactory;
import org.sonar.batch.scan.filesystem.InputFileCache;

public class FileIndexer
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndexer.class);
    private static final IOFileFilter DIR_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{HiddenFileFilter.VISIBLE, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"."))});
    private static final IOFileFilter FILE_FILTER = HiddenFileFilter.VISIBLE;
    private final List<InputFileFilter> filters;
    private final InputFileCache fileCache;
    private final boolean isAggregator;
    private final ExclusionFilters exclusionFilters;
    private final InputFileBuilderFactory inputFileBuilderFactory;

    public FileIndexer(List<InputFileFilter> filters, ExclusionFilters exclusionFilters, InputFileBuilderFactory inputFileBuilderFactory, InputFileCache cache, Project module, ProjectDefinition def) {
        this(filters, exclusionFilters, inputFileBuilderFactory, cache, !module.getModules().isEmpty());
    }

    public FileIndexer(List<InputFileFilter> filters, ExclusionFilters exclusionFilters, InputFileBuilderFactory inputFileBuilderFactory, InputFileCache cache, ProjectDefinition def) {
        this(filters, exclusionFilters, inputFileBuilderFactory, cache, !def.getSubProjects().isEmpty());
    }

    private FileIndexer(List<InputFileFilter> filters, ExclusionFilters exclusionFilters, InputFileBuilderFactory inputFileBuilderFactory, InputFileCache cache, boolean isAggregator) {
        this.filters = filters;
        this.exclusionFilters = exclusionFilters;
        this.inputFileBuilderFactory = inputFileBuilderFactory;
        this.fileCache = cache;
        this.isAggregator = isAggregator;
    }

    void index(DefaultModuleFileSystem fileSystem) {
        if (this.isAggregator) {
            return;
        }
        LOG.info("Index files");
        this.exclusionFilters.prepare();
        Progress progress = new Progress(this.fileCache.byModule(fileSystem.moduleKey()));
        InputFileBuilder inputFileBuilder = this.inputFileBuilderFactory.create(fileSystem);
        if (!fileSystem.sourceFiles().isEmpty() || !fileSystem.testFiles().isEmpty()) {
            this.indexFiles(inputFileBuilder, fileSystem, progress, fileSystem.sourceFiles(), InputFile.Type.MAIN);
            this.indexFiles(inputFileBuilder, fileSystem, progress, fileSystem.testFiles(), InputFile.Type.TEST);
        } else {
            for (File mainDir : fileSystem.sourceDirs()) {
                this.indexDirectory(inputFileBuilder, fileSystem, progress, mainDir, InputFile.Type.MAIN);
            }
            for (File testDir : fileSystem.testDirs()) {
                this.indexDirectory(inputFileBuilder, fileSystem, progress, testDir, InputFile.Type.TEST);
            }
        }
        for (InputFile removed : progress.removed) {
            this.fileCache.remove(fileSystem.moduleKey(), removed);
        }
        LOG.info(String.format("%d files indexed", progress.count()));
    }

    private void indexFiles(InputFileBuilder inputFileBuilder, DefaultModuleFileSystem fileSystem, Progress progress, List<File> sourceFiles, InputFile.Type type) {
        for (File sourceFile : sourceFiles) {
            DeprecatedDefaultInputFile inputFile = inputFileBuilder.create(sourceFile);
            if (inputFile == null || !this.exclusionFilters.accept((InputFile)inputFile, type)) continue;
            this.indexFile(inputFileBuilder, fileSystem, progress, inputFile, type);
        }
    }

    private void indexDirectory(InputFileBuilder inputFileBuilder, DefaultModuleFileSystem fileSystem, Progress status, File dirToIndex, InputFile.Type type) {
        Collection files = FileUtils.listFiles((File)dirToIndex, (IOFileFilter)FILE_FILTER, (IOFileFilter)DIR_FILTER);
        for (File file : files) {
            DeprecatedDefaultInputFile inputFile = inputFileBuilder.create(file);
            if (inputFile == null || !this.exclusionFilters.accept((InputFile)inputFile, type)) continue;
            this.indexFile(inputFileBuilder, fileSystem, status, inputFile, type);
        }
    }

    private void indexFile(InputFileBuilder inputFileBuilder, DefaultModuleFileSystem fs, Progress status, DeprecatedDefaultInputFile inputFile, InputFile.Type type) {
        DeprecatedDefaultInputFile completedFile = inputFileBuilder.complete(inputFile, type);
        if (completedFile != null && this.accept((InputFile)completedFile)) {
            fs.add((InputFile)completedFile);
            status.markAsIndexed((InputFile)completedFile);
        }
    }

    private boolean accept(InputFile inputFile) {
        for (InputFileFilter filter : this.filters) {
            if (filter.accept(inputFile)) continue;
            return false;
        }
        return true;
    }

    private static class Progress {
        private final Set<InputFile> removed;
        private final Set<InputFile> indexed;

        Progress(Iterable<InputFile> removed) {
            this.removed = Sets.newHashSet(removed);
            this.indexed = new HashSet<InputFile>();
        }

        void markAsIndexed(InputFile inputFile) {
            if (this.indexed.contains(inputFile)) {
                throw MessageException.of((String)("File " + inputFile + " can't be indexed twice. Please check that inclusion/exclusion patterns produce " + "disjoint sets for main and test files"));
            }
            this.removed.remove(inputFile);
            this.indexed.add(inputFile);
        }

        int count() {
            return this.indexed.size();
        }
    }
}

