/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.source;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.component.Component;
import org.sonar.api.source.Highlightable;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.source.DefaultHighlightable;
import org.sonar.core.component.PerspectiveBuilder;
import org.sonar.core.component.ResourceComponent;

public class HighlightableBuilder
extends PerspectiveBuilder<Highlightable> {
    private static final Set<String> SUPPORTED_QUALIFIERS = ImmutableSet.of((Object)"FIL", (Object)"UTS");
    private final ComponentDataCache cache;

    public HighlightableBuilder(ComponentDataCache cache) {
        super(Highlightable.class);
        this.cache = cache;
    }

    @CheckForNull
    protected Highlightable loadPerspective(Class<Highlightable> perspectiveClass, Component component) {
        boolean supported = SUPPORTED_QUALIFIERS.contains(component.qualifier());
        if (supported && component instanceof ResourceComponent) {
            return new DefaultHighlightable(component, this.cache);
        }
        return null;
    }
}

