/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.skin.ButtonBarSkin;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class ButtonBar
extends Control {
    public static final String BUTTON_ORDER_WINDOWS = "L_E+U+FBXI_YNOCAH_R";
    public static final String BUTTON_ORDER_MAC_OS = "L_HE+U+FBIX_NCYOA_R";
    public static final String BUTTON_ORDER_LINUX = "L_HE+UNYACBXIO_R";
    public static final String BUTTON_ORDER_NONE = "";
    private ObservableList<Node> buttons = FXCollections.observableArrayList();
    private final StringProperty buttonOrderProperty = new SimpleStringProperty((Object)this, "buttonOrder");
    private final DoubleProperty buttonMinWidthProperty = new SimpleDoubleProperty((Object)this, "buttonMinWidthProperty");

    public static void setButtonData(Node button, ButtonData buttonData) {
        ObservableMap properties = button.getProperties();
        ObjectProperty property = (ObjectProperty)properties.getOrDefault("javafx.scene.control.ButtonBar.ButtonData", new SimpleObjectProperty((Object)button, "buttonData", (Object)buttonData));
        property.set((Object)buttonData);
        properties.putIfAbsent("javafx.scene.control.ButtonBar.ButtonData", property);
    }

    public static ButtonData getButtonData(Node button) {
        ObservableMap properties = button.getProperties();
        if (properties.containsKey("javafx.scene.control.ButtonBar.ButtonData")) {
            ObjectProperty property = (ObjectProperty)properties.get("javafx.scene.control.ButtonBar.ButtonData");
            return property == null ? null : (ButtonData)((Object)property.get());
        }
        return null;
    }

    public static void setButtonUniformSize(Node button, boolean uniformSize) {
        if (uniformSize) {
            button.getProperties().remove((Object)"javafx.scene.control.ButtonBar.independentSize");
        } else {
            button.getProperties().put((Object)"javafx.scene.control.ButtonBar.independentSize", (Object)uniformSize);
        }
    }

    public static boolean isButtonUniformSize(Node button) {
        return (Boolean)button.getProperties().getOrDefault((Object)"javafx.scene.control.ButtonBar.independentSize", (Object)true);
    }

    public ButtonBar() {
        this(null);
    }

    public ButtonBar(String buttonOrder) {
        boolean buttonOrderEmpty;
        this.getStyleClass().add((Object)"button-bar");
        ((StyleableProperty)this.focusTraversableProperty()).applyStyle(null, (Object)Boolean.FALSE);
        boolean bl = buttonOrderEmpty = buttonOrder == null || buttonOrder.isEmpty();
        if (Utils.isMac()) {
            this.setButtonOrder(buttonOrderEmpty ? BUTTON_ORDER_MAC_OS : buttonOrder);
            this.setButtonMinWidth(70.0);
        } else if (Utils.isUnix()) {
            this.setButtonOrder(buttonOrderEmpty ? BUTTON_ORDER_LINUX : buttonOrder);
            this.setButtonMinWidth(85.0);
        } else {
            this.setButtonOrder(buttonOrderEmpty ? BUTTON_ORDER_WINDOWS : buttonOrder);
            this.setButtonMinWidth(75.0);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new ButtonBarSkin(this);
    }

    public final ObservableList<Node> getButtons() {
        return this.buttons;
    }

    public final StringProperty buttonOrderProperty() {
        return this.buttonOrderProperty;
    }

    public final void setButtonOrder(String buttonOrder) {
        this.buttonOrderProperty.set((Object)buttonOrder);
    }

    public final String getButtonOrder() {
        return (String)this.buttonOrderProperty.get();
    }

    public final DoubleProperty buttonMinWidthProperty() {
        return this.buttonMinWidthProperty;
    }

    public final void setButtonMinWidth(double value) {
        this.buttonMinWidthProperty.set(value);
    }

    public final double getButtonMinWidth() {
        return this.buttonMinWidthProperty.get();
    }

    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }

    public static enum ButtonData {
        LEFT("L", false, false),
        RIGHT("R", false, false),
        HELP("H", false, false),
        HELP_2("E", false, false),
        YES("Y", false, true),
        NO("N", true, false),
        NEXT_FORWARD("X", false, true),
        BACK_PREVIOUS("B", false, false),
        FINISH("I", false, true),
        APPLY("A", false, false),
        CANCEL_CLOSE("C", true, false),
        OK_DONE("O", false, true),
        OTHER("U", false, false),
        BIG_GAP("+", false, false),
        SMALL_GAP("_", false, false);

        private final String typeCode;
        private final boolean cancelButton;
        private final boolean defaultButton;

        private ButtonData(String type, boolean cancelButton, boolean defaultButton) {
            this.typeCode = type;
            this.cancelButton = cancelButton;
            this.defaultButton = defaultButton;
        }

        public String getTypeCode() {
            return this.typeCode;
        }

        public final boolean isCancelButton() {
            return this.cancelButton;
        }

        public final boolean isDefaultButton() {
            return this.defaultButton;
        }
    }
}

