/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Principal;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.server.Environment;
import org.crsh.console.jline.JLineProcessor;
import org.crsh.console.jline.Terminal;
import org.crsh.console.jline.console.ConsoleReader;
import org.crsh.shell.Shell;
import org.crsh.ssh.term.AbstractCommand;
import org.crsh.ssh.term.CRaSHCommandFactory;
import org.crsh.ssh.term.SSHContext;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.util.Utils;

public class CRaSHCommand
extends AbstractCommand
implements Runnable,
Terminal {
    protected static final Logger log = Logger.getLogger(CRaSHCommand.class.getName());
    private final CRaSHCommandFactory factory;
    private Thread thread;
    private String encoding;
    private SSHContext context;
    private JLineProcessor console;

    public CRaSHCommand(CRaSHCommandFactory factory) {
        this.factory = factory;
    }

    public void start(Environment env) throws IOException {
        this.context = new SSHContext(env);
        this.encoding = this.context.encoding != null ? this.context.encoding.name() : this.factory.encoding.name();
        this.thread = new Thread((Runnable)this, "CRaSH");
        this.thread.start();
    }

    public SSHContext getContext() {
        return this.context;
    }

    public void destroy() {
        Utils.close((Closeable)this.console);
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final AtomicBoolean exited = new AtomicBoolean(false);
        try {
            final String userName = (String)this.session.getAttribute(SSHLifeCycle.USERNAME);
            Principal user = new Principal(){

                @Override
                public String getName() {
                    return userName;
                }
            };
            Shell shell = this.factory.shellFactory.create(user);
            ConsoleReader reader = new ConsoleReader(this.in, this.out, this){

                public void shutdown() {
                    exited.set(true);
                    CRaSHCommand.this.callback.onExit(0);
                    super.shutdown();
                }
            };
            JLineProcessor processor = new JLineProcessor(true, shell, reader, new PrintStream(this.out, false, this.encoding), "\r\n");
            processor.run();
        }
        catch (InterruptedIOException e) {
            Thread.interrupted();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error during execution", e);
        }
        finally {
            if (!exited.get()) {
                this.callback.onExit(0);
            }
        }
    }

    public String getOutputEncoding() {
        return this.encoding;
    }

    public void init() throws Exception {
    }

    public void restore() throws Exception {
    }

    public void reset() throws Exception {
    }

    public boolean isSupported() {
        return true;
    }

    public int getWidth() {
        return this.context.getWidth();
    }

    public int getHeight() {
        return this.context.getHeight();
    }

    public boolean isAnsiSupported() {
        return true;
    }

    public OutputStream wrapOutIfNeeded(OutputStream out) {
        return out;
    }

    public InputStream wrapInIfNeeded(InputStream in) throws IOException {
        return in;
    }

    public boolean hasWeirdWrap() {
        return false;
    }

    public boolean isEchoEnabled() {
        return false;
    }

    public void setEchoEnabled(boolean enabled) {
    }
}

