/**
 * The MIT License
 * Copyright (c) 2013 Cube Island
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.cubeengine.converter.converter;

import org.cubeengine.converter.ConversionException;
import org.cubeengine.converter.node.LongNode;
import org.cubeengine.converter.node.Node;

/**
 * A Converter for {@link java.lang.Long}
 */
public class LongConverter extends SimpleConverter<Long>
{
    @Override
    public Node toNode(Long object) throws ConversionException
    {
        return new LongNode(object);
    }

    @Override
    public Long fromNode(Node node) throws ConversionException
    {
        if (node instanceof LongNode)
        {
            return ((LongNode)node).getValue();
        }
        String s = node.asText();
        try
        {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e)
        {
            throw ConversionException.of(this, node, "Node incompatible with Long!", e);
        }
    }
}
