/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.compute.AbstractVolumeSupport;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.vcloud.vCloud;
import org.dasein.cloud.vcloud.vCloudMethod;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiskSupport
extends AbstractVolumeSupport {
    private static final Logger logger = vCloud.getLogger(DiskSupport.class);

    DiskSupport(@Nonnull vCloud provider) {
        super((CloudProvider)provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(@Nonnull String volumeId, @Nonnull String toServer, @Nonnull String deviceId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.attachVolume");
        try {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            StringBuilder xml = new StringBuilder();
            xml.append("<DiskAttachOrDetachParams xmlns=\"http://www.vmware.com/vcloud/v1.5\">");
            xml.append("<Disk type=\"application/vnd.vmware.vcloud.disk+xml\" href=\"").append(method.toURL("disk", volumeId)).append("\" />");
            xml.append("</DiskAttachOrDetachParams>");
            method.waitFor(method.post("attachVolume", method.toURL("vApp", toServer) + "/disk/action/attach", method.getMediaTypeForActionAttachVolume(), xml.toString()));
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions options) throws InternalException, CloudException {
        if (options.getFormat().equals((Object)VolumeFormat.NFS)) {
            throw new OperationNotSupportedException("NFS volumes are not currently implemented for " + this.getProvider().getCloudName());
        }
        if (options.getSnapshotId() != null) {
            throw new OperationNotSupportedException("Volumes created from snapshots make no sense when there are no snapshots");
        }
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.createVolume");
        try {
            NodeList disks;
            if (!this.isSubscribed()) {
                throw new OperationNotSupportedException("This account is not subscribed for creating volume");
            }
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            String vdcId = options.getDataCenterId();
            if (vdcId == null) {
                vdcId = ((DataCenter)this.getProvider().getDataCenterServices().listDataCenters(this.getContext().getRegionId()).iterator().next()).getProviderDataCenterId();
            }
            long size = options.getVolumeSize().convertTo((UnitOfMeasure)Storage.BYTE).longValue();
            StringBuilder xml = new StringBuilder();
            xml.append("<DiskCreateParams xmlns=\"http://www.vmware.com/vcloud/v1.5\">");
            xml.append("<Disk name=\"").append(vCloud.escapeXml(options.getName())).append("\" ");
            xml.append("size=\"").append(String.valueOf(size)).append("\">");
            xml.append("<Description>").append(vCloud.escapeXml(options.getDescription())).append("</Description>");
            xml.append("</Disk>");
            xml.append("</DiskCreateParams>");
            String response = method.post("createDisk", vdcId, xml.toString());
            if (response.length() < 1) {
                throw new CloudException("No error, but no volume");
            }
            Document doc = method.parseXML(response);
            String docElementTagName = doc.getDocumentElement().getTagName();
            String nsString = "";
            if (docElementTagName.contains(":")) {
                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
            }
            if ((disks = doc.getElementsByTagName(nsString + "Disk")).getLength() < 1) {
                throw new CloudException("No error, but no volume");
            }
            Node disk = disks.item(0);
            Node href = disk.getAttributes().getNamedItem("href");
            if (href != null) {
                String volumeId = ((vCloud)this.getProvider()).toID(href.getNodeValue().trim());
                try {
                    HashMap<String, Object> meta = options.getMetaData();
                    if (meta == null) {
                        meta = new HashMap<String, Object>();
                    }
                    meta.put("dsnCreated", System.currentTimeMillis());
                    meta.put("dsnDeviceId", options.getDeviceId());
                    method.postMetaData("disk", volumeId, meta);
                }
                catch (Throwable ignore) {
                    logger.warn((Object)("Error updating meta-data on volume creation: " + ignore.getMessage()));
                }
                String vmId = options.getVlanId();
                if (vmId != null) {
                    long timeout = System.currentTimeMillis() + 600000L;
                    while (timeout > System.currentTimeMillis()) {
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        try {
                            Volume v = this.getVolume(volumeId);
                            if (v == null || !v.getCurrentState().equals((Object)VolumeState.AVAILABLE)) continue;
                            break;
                        }
                        catch (Throwable ignore) {
                        }
                    }
                    try {
                        this.attach(volumeId, vmId, options.getDeviceId());
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                String string = volumeId;
                return string;
            }
            throw new CloudException("No ID provided in Disk XML");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(@Nonnull String volumeId, boolean force) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.detach");
        try {
            Volume volume = this.getVolume(volumeId);
            if (volume == null) {
                throw new CloudException("No such volume: " + volumeId);
            }
            String serverId = volume.getProviderVirtualMachineId();
            if (serverId == null) {
                throw new CloudException("No virtual machine is attached to this volume");
            }
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            StringBuilder xml = new StringBuilder();
            xml.append("<DiskAttachOrDetachParams xmlns=\"http://www.vmware.com/vcloud/v1.5\">");
            xml.append("<Disk href=\"").append(method.toURL("disk", volumeId)).append("\" />");
            xml.append("</DiskAttachOrDetachParams>");
            method.waitFor(method.post("detachVolume", method.toURL("vApp", serverId) + "/disk/action/detach", method.getMediaTypeForActionAttachVolume(), xml.toString()));
        }
        finally {
            APITrace.end();
        }
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "disk";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Volume getVolume(@Nonnull String volumeId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.getVolume");
        try {
            for (Volume v : this.listVolumes()) {
                if (!v.getProviderVolumeId().equals(volumeId)) continue;
                Volume volume = v;
                return volume;
            }
            Volume volume = null;
            return volume;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 5; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                ids.add(i + ":" + j);
            }
        }
        return ids;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVolumeStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.listVolumeStatus");
        try {
            Iterable iterable = super.listVolumeStatus();
            return iterable;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.listVolumes");
        try {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            ArrayList<Volume> volumes = new ArrayList<Volume>();
            for (DataCenter dc : method.listDataCenters()) {
                NodeList vdcs;
                String xml = method.get("vdc", dc.getProviderDataCenterId());
                if (xml == null || xml.equals("")) continue;
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                if ((vdcs = doc.getElementsByTagName(nsString + "Vdc")).getLength() <= 0) continue;
                NodeList attributes = vdcs.item(0).getChildNodes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
                    if (!attribute.getNodeName().equalsIgnoreCase(nsString + "ResourceEntities") || !attribute.hasChildNodes()) continue;
                    NodeList resources = attribute.getChildNodes();
                    for (int j = 0; j < resources.getLength(); ++j) {
                        Node type;
                        Node resource = resources.item(j);
                        nsString = resource.getNodeName().contains(":") ? resource.getNodeName().substring(0, resource.getNodeName().indexOf(":") + 1) : "";
                        if (!resource.getNodeName().equalsIgnoreCase(nsString + "ResourceEntity") || !resource.hasAttributes() || (type = resource.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().equals(method.getMediaTypeForDisk())) continue;
                        Node href = resource.getAttributes().getNamedItem("href");
                        Volume volume = this.toVolume(dc.getProviderDataCenterId(), ((vCloud)this.getProvider()).toID(href.getNodeValue().trim()));
                        if (volume == null) continue;
                        volumes.add(volume);
                    }
                }
            }
            ArrayList<Volume> arrayList = volumes;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.isSubscribed");
        try {
            if (this.getProvider().testContext() != null) {
                vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
                boolean bl = vCloudMethod.matches(method.getAPIVersion(), "5.1", null);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String volumeId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.remove");
        try {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            method.delete("disk", volumeId);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private VolumeState toState(@Nonnull String status) {
        if (status.equals("1")) {
            return VolumeState.AVAILABLE;
        }
        if (status.equals("0")) {
            return VolumeState.PENDING;
        }
        return VolumeState.PENDING;
    }

    @Nullable
    private Volume toVolume(@Nonnull String dcId, @Nonnull String volumeId) throws CloudException, InternalException {
        String nsString;
        String docElementTagName;
        Document doc;
        String xml;
        Volume volume;
        vCloudMethod method;
        block23: {
            NodeList disks;
            method = new vCloudMethod((vCloud)this.getProvider());
            volume = new Volume();
            volume.setProviderVolumeId(volumeId);
            volume.setCurrentState(VolumeState.AVAILABLE);
            volume.setFormat(VolumeFormat.BLOCK);
            volume.setType(VolumeType.HDD);
            volume.setProviderRegionId(this.getContext().getRegionId());
            volume.setProviderDataCenterId(dcId);
            volume.setRootVolume(false);
            xml = method.get("disk", volumeId);
            if (xml == null || xml.length() < 1) {
                return null;
            }
            doc = method.parseXML(xml);
            docElementTagName = doc.getDocumentElement().getTagName();
            nsString = "";
            if (docElementTagName.contains(":")) {
                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
            }
            if ((disks = doc.getElementsByTagName(nsString + "Disk")).getLength() < 1) {
                return null;
            }
            Node diskNode = disks.item(0);
            Node n = diskNode.getAttributes().getNamedItem("name");
            if (n != null) {
                volume.setName(n.getNodeValue().trim());
            }
            if ((n = diskNode.getAttributes().getNamedItem("size")) != null) {
                try {
                    volume.setSize(new Storage((Number)Integer.parseInt(n.getNodeValue().trim()), (StorageUnit)Storage.BYTE));
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (volume.getSize() == null) {
                volume.setSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
            }
            if ((n = diskNode.getAttributes().getNamedItem("status")) != null) {
                volume.setCurrentState(this.toState(n.getNodeValue().trim()));
            }
            NodeList attributes = diskNode.getChildNodes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (!attribute.getNodeName().equalsIgnoreCase(nsString + "Description") || !attribute.hasChildNodes()) continue;
                volume.setDescription(attribute.getFirstChild().getNodeValue().trim());
            }
            try {
                xml = method.get("disk", volumeId + "/metadata");
                if (xml == null || xml.equals("") || xml == null || xml.equals("")) break block23;
                method.parseMetaData((Taggable)volume, xml);
                String t = volume.getTag("dsnCreated");
                if (t != null) {
                    try {
                        volume.setCreationTimestamp(Long.parseLong(t));
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if ((t = volume.getTag("dsnDeviceId")) != null) {
                    volume.setDeviceId(t);
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        try {
            xml = method.get("disk", volumeId + "/attachedVms");
            if (xml != null && !xml.equals("")) {
                Node vm;
                Node href;
                NodeList vms;
                doc = method.parseXML(xml);
                docElementTagName = doc.getDocumentElement().getTagName();
                nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                if ((vms = doc.getElementsByTagName(nsString + "VmReference")).getLength() > 0 && (href = (vm = vms.item(0)).getAttributes().getNamedItem("href")) != null) {
                    volume.setProviderVirtualMachineId(((vCloud)this.getProvider()).toID(href.getNodeValue().trim()));
                }
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        if (volume.getName() == null) {
            volume.setName(volume.getProviderVolumeId());
        }
        if (volume.getDescription() == null) {
            volume.setDescription(volume.getName());
        }
        return volume;
    }
}

