/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud.compute;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.vcloud.vCloud;
import org.dasein.cloud.vcloud.vCloudMethod;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateSupport
extends AbstractImageSupport {
    private static final Logger logger = vCloud.getLogger(TemplateSupport.class);
    private static final Lock lockCreationLock = new ReentrantLock();

    public TemplateSupport(@Nonnull vCloud cloud) {
        super((CloudProvider)cloud);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.capture");
        try {
            MachineImage machineImage;
            block28: {
                String vAppId;
                vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
                String vmId = options.getVirtualMachineId();
                if (vmId == null) {
                    throw new CloudException("A capture operation requires a valid VM ID");
                }
                VirtualMachine vm = ((vCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
                String string = vAppId = vm == null ? null : (String)vm.getTag("parentVAppId");
                if (vm == null) {
                    throw new CloudException("No such virtual machine: " + vmId);
                }
                if (vAppId == null) {
                    throw new CloudException("Unable to determine virtual machine vApp for capture: " + vmId);
                }
                long timeout = System.currentTimeMillis() + 600000L;
                while (timeout > System.currentTimeMillis()) {
                    if (vm == null) {
                        throw new CloudException("VM " + vmId + " went away");
                    }
                    if (!vm.getCurrentState().equals((Object)VmState.PENDING)) break;
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    try {
                        vm = ((vCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
                    }
                    catch (Throwable ignore) {}
                }
                boolean running = !vm.getCurrentState().equals((Object)VmState.STOPPED);
                String vappId = (String)vm.getTag("parentVAppId");
                if (running) {
                    ((vCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().undeploy(vappId, "shutdown");
                }
                try {
                    String endpoint = method.toURL("vApp", vAppId);
                    StringBuilder xml = new StringBuilder();
                    xml.append("<CaptureVAppParams xmlns=\"http://www.vmware.com/vcloud/v1.5\" xmlns:ovf=\"http://schemas.dmtf.org/ovf/envelope/1\" name=\"").append(vCloud.escapeXml(options.getName())).append("\">");
                    xml.append("<Description>").append(options.getDescription()).append("</Description>");
                    xml.append("<Source href=\"").append(endpoint).append("\" type=\"").append(method.getMediaTypeForVApp()).append("\"/>");
                    xml.append("<CustomizationSection><ovf:Info/><CustomizeOnInstantiate>true</CustomizeOnInstantiate></CustomizationSection>");
                    xml.append("</CaptureVAppParams>");
                    String response = method.post("captureVApp", vm.getProviderDataCenterId(), xml.toString());
                    if (response.equals("")) {
                        throw new CloudException("No error or other information was in the response");
                    }
                    Document doc = method.parseXML(response);
                    try {
                        method.checkError(doc);
                    }
                    catch (CloudException e) {
                        if (e.getMessage().contains("Stop the vApp and try again")) {
                            logger.warn((Object)("The cloud thinks the vApp or VM is still running; going to check what's going on: " + e.getMessage()));
                            vm = ((vCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
                            if (vm == null) {
                                throw new CloudException("Virtual machine went away");
                            }
                            if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                                logger.warn((Object)("Current state of VM: " + vm.getCurrentState()));
                                ((vCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().undeploy(vappId, "shutdown");
                            }
                            if ((response = method.post("captureVApp", vm.getProviderDataCenterId(), xml.toString())).equals("")) {
                                throw new CloudException("No error or other information was in the response");
                            }
                            doc = method.parseXML(response);
                            method.checkError(doc);
                        }
                        throw e;
                    }
                    NodeList vapps = doc.getElementsByTagName("VAppTemplate");
                    if (vapps.getLength() < 1) {
                        throw new CloudException("No vApp templates were found in response");
                    }
                    Node vapp = vapps.item(0);
                    String imageId = null;
                    Node href = vapp.getAttributes().getNamedItem("href");
                    if (href != null) {
                        imageId = ((vCloud)this.getProvider()).toID(href.getNodeValue().trim());
                    }
                    if (imageId == null || imageId.length() < 1) {
                        throw new CloudException("No imageId was found in response");
                    }
                    MachineImage img = this.loadVapp(imageId, this.getContext().getAccountNumber(), false, options.getName(), options.getDescription(), System.currentTimeMillis());
                    if (img == null) {
                        throw new CloudException("Image was lost");
                    }
                    method.waitFor(response);
                    this.publish(img);
                    machineImage = img;
                    if (!running) break block28;
                }
                catch (Throwable throwable) {
                    if (running) {
                        ((vCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().deploy(vappId);
                    }
                    throw throwable;
                }
                ((vCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().deploy(vappId);
            }
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    private void publish(@Nonnull MachineImage img) throws CloudException, InternalException {
        StringBuilder xml;
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        Catalog c = null;
        for (Catalog catalog : this.listPrivateCatalogs()) {
            if (!catalog.owner.equals(this.getContext().getAccountNumber())) continue;
            c = catalog;
            if (!catalog.name.equals("Standard Catalog")) continue;
            break;
        }
        if (c == null) {
            xml = new StringBuilder();
            xml.append("<AdminCatalog xmlns=\"http://www.vmware.com/vcloud/v1.5\" name=\"Standard Catalog\">");
            xml.append("<Description>Standard catalog for custom vApp templates</Description>");
            xml.append("<IsPublished>false</IsPublished>");
            xml.append("</AdminCatalog>");
            String response = method.post("createCatalog", method.toAdminURL("org", this.getContext().getRegionId()) + "/catalogs", method.getMediaTypeForActionAddCatalog(), xml.toString());
            String href = null;
            method.waitFor(response);
            if (!response.equals("")) {
                Document doc = method.parseXML(response);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                NodeList matches = doc.getElementsByTagName(nsString + "AdminCatalog");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Node m = matches.item(i);
                    Node h = m.getAttributes().getNamedItem("href");
                    if (h == null) continue;
                    href = h.getNodeValue().trim();
                    break;
                }
            }
            if (href == null) {
                throw new CloudException("No catalog could be identified for publishing vApp template " + img.getProviderMachineImageId());
            }
            c = this.getCatalog(false, href);
            if (c == null) {
                throw new CloudException("No catalog could be identified for publishing vApp template " + img.getProviderMachineImageId());
            }
        }
        xml = new StringBuilder();
        xml.append("<CatalogItem xmlns=\"http://www.vmware.com/vcloud/v1.5\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        xml.append("name=\"").append(vCloud.escapeXml(img.getName())).append("\">");
        xml.append("<Description>").append(vCloud.escapeXml(img.getDescription())).append("</Description>");
        xml.append("<Entity href=\"").append(method.toURL("vAppTemplate", img.getProviderMachineImageId())).append("\" ");
        xml.append("name=\"").append(vCloud.escapeXml(img.getName())).append("\" ");
        xml.append("type=\"").append(method.getMediaTypeForVAppTemplate()).append("\" xsi:type=\"").append("ResourceReferenceType\"/>");
        xml.append("</CatalogItem>");
        method.waitFor(method.post("publish", method.toURL("catalog", c.catalogId) + "/catalogItems", method.getMediaTypeForCatalogItem(), xml.toString()));
    }

    @Nullable
    private Catalog getCatalog(boolean published, @Nonnull String href) throws CloudException, InternalException {
        String catalogId = ((vCloud)this.getProvider()).toID(href);
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("catalog", catalogId);
        if (xml == null) {
            logger.warn((Object)("Unable to find catalog " + catalogId + " indicated by org " + this.getContext().getAccountNumber()));
            return null;
        }
        Document doc = method.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        NodeList cNodes = doc.getElementsByTagName(nsString + "Catalog");
        for (int i = 0; i < cNodes.getLength(); ++i) {
            Node cnode = cNodes.item(i);
            Node name = cnode.getAttributes().getNamedItem("name");
            String catalogName = null;
            if (name != null) {
                catalogName = name.getNodeValue().trim();
            }
            if (!cnode.hasChildNodes()) continue;
            NodeList attributes = cnode.getChildNodes();
            String owner = "--public--";
            boolean p = false;
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node h;
                Node type;
                Node rel;
                Node attribute = attributes.item(j);
                nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
                if (attribute.getNodeName().equalsIgnoreCase(nsString + "IsPublished")) {
                    p = attribute.hasChildNodes() && attribute.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true");
                    continue;
                }
                if (!attribute.getNodeName().equalsIgnoreCase(nsString + "Link") || !attribute.hasAttributes() || (rel = attribute.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("up") || (type = attribute.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().trim().equalsIgnoreCase(method.getMediaTypeForOrg()) || (h = attribute.getAttributes().getNamedItem("href")) == null) continue;
                owner = method.getOrgName(h.getNodeValue().trim());
            }
            if (p != published) continue;
            Catalog catalog = new Catalog();
            catalog.catalogId = ((vCloud)this.getProvider()).toID(href);
            catalog.published = p;
            catalog.owner = owner;
            catalog.name = catalogName;
            return catalog;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.getImage");
        try {
            for (MachineImage image : this.listImages(null)) {
                if (!image.getProviderMachineImageId().equals(providerImageId)) continue;
                MachineImage machineImage = image;
                return machineImage;
            }
            for (MachineImage image : this.searchPublicImages(null)) {
                if (!image.getProviderMachineImageId().equals(providerImageId)) continue;
                MachineImage machineImage = image;
                return machineImage;
            }
            MachineImage machineImage = null;
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return "vApp Template";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.isImageSharedWithPublic");
        try {
            MachineImage img = this.getImage(machineImageId);
            if (img == null) {
                boolean bl = false;
                return bl;
            }
            Boolean p = (Boolean)img.getTag("public");
            boolean bl = p != null && p != false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.isSubscribed");
        try {
            boolean bl = this.getProvider().testContext() != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    private Iterable<Catalog> listPublicCatalogs() throws CloudException, InternalException {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"publicCatalogs", Catalog.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)30, (TimePeriodUnit)TimePeriod.MINUTE));
        List catalogs = cache.get(this.getContext());
        if (catalogs == null) {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            String xml = method.get("org", this.getContext().getRegionId());
            if (xml == null) {
                catalogs = Collections.emptyList();
            } else {
                ArrayList list = new ArrayList();
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                NodeList links = doc.getElementsByTagName(nsString + "Link");
                for (int i = 0; i < links.getLength(); ++i) {
                    Node href;
                    Catalog c;
                    Node type;
                    Node rel;
                    Node link = links.item(i);
                    if (!link.hasAttributes() || (rel = link.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("down") || (type = link.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().trim().equals(method.getMediaTypeForCatalog()) || (c = this.getCatalog(true, (href = link.getAttributes().getNamedItem("href")).getNodeValue().trim())) == null) continue;
                    list.add(c);
                }
                catalogs = list;
            }
            cache.put(this.getContext(), catalogs);
        }
        return catalogs;
    }

    private Iterable<Catalog> listPrivateCatalogs() throws CloudException, InternalException {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"privateCatalogs", Catalog.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)30, (TimePeriodUnit)TimePeriod.MINUTE));
        List catalogs = cache.get(this.getContext());
        if (catalogs == null) {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            String xml = method.get("org", this.getContext().getRegionId());
            if (xml == null) {
                catalogs = Collections.emptyList();
            } else {
                ArrayList list = new ArrayList();
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                NodeList links = doc.getElementsByTagName(nsString + "Link");
                for (int i = 0; i < links.getLength(); ++i) {
                    Node href;
                    Catalog c;
                    Node type;
                    Node rel;
                    Node link = links.item(i);
                    if (!link.hasAttributes() || (rel = link.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("down") || (type = link.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().trim().equals(method.getMediaTypeForCatalog()) || (c = this.getCatalog(false, (href = link.getAttributes().getNamedItem("href")).getNodeValue().trim())) == null) continue;
                    list.add(c);
                }
                catalogs = list;
            }
            cache.put(this.getContext(), catalogs);
        }
        return catalogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> listImages(@Nullable ImageFilterOptions options) throws CloudException, InternalException {
        Object onelock;
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"listImages", MachineImage.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)6, (TimePeriodUnit)TimePeriod.MINUTE));
        Iterable imageList = cache.get(this.getContext());
        if (imageList != null) {
            return imageList;
        }
        Cache lockCache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"listImagesLock", Lock.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)500, (TimePeriodUnit)TimePeriod.WEEK));
        Iterable lockList = lockCache.get(this.getContext());
        if (lockList == null) {
            lockCreationLock.lock();
            try {
                if (lockList == null) {
                    ArrayList<ReentrantLock> oneLockList = new ArrayList<ReentrantLock>();
                    oneLockList.add(new ReentrantLock());
                    lockCache.put(this.getContext(), oneLockList);
                }
                lockList = lockCache.get(this.getContext());
            }
            finally {
                lockCreationLock.unlock();
            }
        }
        Lock lock = null;
        Iterator i$ = lockList.iterator();
        if (i$.hasNext()) {
            onelock = (Lock)i$.next();
            lock = onelock;
        }
        if (lock == null) {
            throw new InternalException("No lock.");
        }
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImages");
        lock.lock();
        try {
            Iterable imageList2 = cache.get(this.getContext());
            if (imageList2 != null) {
                onelock = imageList2;
                return onelock;
            }
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            for (Catalog catalog : this.listPrivateCatalogs()) {
                vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
                String xml = method.get("catalog", catalog.catalogId);
                if (xml == null) {
                    logger.warn((Object)("Unable to find catalog " + catalog.catalogId + " indicated by org " + this.getContext().getAccountNumber()));
                    continue;
                }
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                NodeList cNodes = doc.getElementsByTagName(nsString + "Catalog");
                for (int i = 0; i < cNodes.getLength(); ++i) {
                    Node cnode = cNodes.item(i);
                    if (!cnode.hasChildNodes()) continue;
                    NodeList items = cnode.getChildNodes();
                    for (int j = 0; j < items.getLength(); ++j) {
                        Node wrapper = items.item(j);
                        nsString = wrapper.getNodeName().contains(":") ? wrapper.getNodeName().substring(0, wrapper.getNodeName().indexOf(":") + 1) : "";
                        if (!wrapper.getNodeName().equalsIgnoreCase(nsString + "CatalogItems") || !wrapper.hasChildNodes()) continue;
                        NodeList entries = wrapper.getChildNodes();
                        for (int k = 0; k < entries.getLength(); ++k) {
                            String catalogItemId;
                            MachineImage image;
                            Node href;
                            Node item = entries.item(k);
                            nsString = item.getNodeName().contains(":") ? item.getNodeName().substring(0, item.getNodeName().indexOf(":") + 1) : "";
                            if (!item.getNodeName().equalsIgnoreCase(nsString + "CatalogItem") || !item.hasAttributes() || (href = item.getAttributes().getNamedItem("href")) == null || (image = this.loadTemplate(catalog.owner, catalogItemId = ((vCloud)this.getProvider()).toID(href.getNodeValue().trim()), catalog.published)) == null || options != null && !options.matches(image)) continue;
                            image.setProviderOwnerId(catalog.owner);
                            image.setTag("catalogItemId", catalogItemId);
                            images.add(image);
                        }
                    }
                }
            }
            cache.put(this.getContext(), images);
            ArrayList<MachineImage> arrayList = images;
            return arrayList;
        }
        finally {
            lock.unlock();
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.VMDK);
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String forMachineImageId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nullable
    private MachineImage loadTemplate(@Nonnull String ownerId, @Nonnull String catalogItemId, boolean published) throws CloudException, InternalException {
        NodeList items;
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("catalogItem", catalogItemId);
        if (xml == null) {
            logger.warn((Object)("Catalog item " + catalogItemId + " is missing from the catalog"));
            return null;
        }
        Document doc = method.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        if ((items = doc.getElementsByTagName(nsString + "CatalogItem")).getLength() < 1) {
            return null;
        }
        Node item = items.item(0);
        if (item.hasAttributes() && item.hasChildNodes()) {
            String n;
            Node name = item.getAttributes().getNamedItem("name");
            String imageName = null;
            String imageDescription = null;
            long createdAt = 0L;
            if (name != null && (n = name.getNodeValue().trim()).length() > 0) {
                imageName = n;
                imageDescription = n;
            }
            NodeList entries = item.getChildNodes();
            String vappId = null;
            for (int i = 0; i < entries.getLength(); ++i) {
                Node href;
                Node entry = entries.item(i);
                if (entry.getNodeName().equalsIgnoreCase("description") && entry.hasChildNodes()) {
                    String d = entry.getFirstChild().getNodeValue().trim();
                    if (d.length() <= 0) continue;
                    imageDescription = d;
                    if (imageName != null) continue;
                    imageName = d;
                    continue;
                }
                if (entry.getNodeName().equalsIgnoreCase("datecreated") && entry.hasChildNodes()) {
                    vCloud cfr_ignored_0 = (vCloud)this.getProvider();
                    createdAt = vCloud.parseTime(entry.getFirstChild().getNodeValue().trim());
                    continue;
                }
                if (!entry.getNodeName().equalsIgnoreCase(nsString + "entity") || !entry.hasAttributes() || (href = entry.getAttributes().getNamedItem("href")) == null) continue;
                vappId = ((vCloud)this.getProvider()).toID(href.getNodeValue().trim());
            }
            if (vappId != null) {
                return this.loadVapp(vappId, ownerId, published, imageName, imageDescription, createdAt);
            }
        }
        return null;
    }

    @Nullable
    private MachineImage loadVapp(@Nonnull String imageId, @Nonnull String ownerId, boolean published, @Nullable String name, @Nullable String description, @Nonnegative long createdAt) throws CloudException, InternalException {
        String n;
        Node node;
        NodeList templates;
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vAppTemplate", imageId);
        if (xml == null) {
            return null;
        }
        Document doc = method.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        if ((templates = doc.getElementsByTagName(nsString + "VAppTemplate")).getLength() < 1) {
            return null;
        }
        Node template = templates.item(0);
        TreeSet<String> childVms = new TreeSet<String>();
        if (name == null && (node = template.getAttributes().getNamedItem("name")) != null && (n = node.getNodeValue().trim()).length() > 0) {
            name = n;
        }
        NodeList attributes = template.getChildNodes();
        Platform platform = Platform.UNKNOWN;
        Architecture architecture = Architecture.I64;
        TagPair tagPair = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node child;
            int j;
            NodeList children;
            Node attribute = attributes.item(i);
            nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
            if (attribute.getNodeName().equalsIgnoreCase(nsString + "description") && description == null && attribute.hasChildNodes()) {
                String d = attribute.getFirstChild().getNodeValue().trim();
                if (d.length() <= 0) continue;
                description = d;
                if (name != null) continue;
                name = d;
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase(nsString + "children") && attribute.hasChildNodes()) {
                children = attribute.getChildNodes();
                for (j = 0; j < children.getLength(); ++j) {
                    child = children.item(j);
                    if (!child.getNodeName().equalsIgnoreCase(nsString + "vm") || !child.hasChildNodes()) continue;
                    Node childHref = child.getAttributes().getNamedItem("href");
                    if (childHref != null) {
                        childVms.add(((vCloud)this.getProvider()).toID(childHref.getNodeValue().trim()));
                    }
                    NodeList vmAttrs = child.getChildNodes();
                    for (int k = 0; k < vmAttrs.getLength(); ++k) {
                        String n2;
                        int l;
                        Node vmAttr = vmAttrs.item(k);
                        if (vmAttr.getNodeName().contains(":")) {
                            nsString = vmAttr.getNodeName().substring(0, vmAttr.getNodeName().indexOf(":") + 1);
                        }
                        if (vmAttr.getNodeName().equalsIgnoreCase(nsString + "guestcustomizationsection") && vmAttr.hasChildNodes()) {
                            NodeList custList = vmAttr.getChildNodes();
                            for (l = 0; l < custList.getLength(); ++l) {
                                Node cust = custList.item(l);
                                if (!cust.getNodeName().equalsIgnoreCase(nsString + "computername") || !cust.hasChildNodes() || (n2 = cust.getFirstChild().getNodeValue().trim()).length() <= 0) continue;
                                name = name == null ? n2 : name + " - " + n2;
                            }
                            continue;
                        }
                        if (vmAttr.getNodeName().equalsIgnoreCase(nsString + "ProductSection") && vmAttr.hasChildNodes()) {
                            NodeList prdList = vmAttr.getChildNodes();
                            for (l = 0; l < prdList.getLength(); ++l) {
                                Node prd = prdList.item(l);
                                if (!prd.getNodeName().equalsIgnoreCase(nsString + "Product") || !prd.hasChildNodes() || (n2 = prd.getFirstChild().getNodeValue().trim()).length() <= 0) continue;
                                platform = Platform.guess((String)n2);
                            }
                            continue;
                        }
                        if (vmAttr.getNodeName().equalsIgnoreCase(nsString + "OperatingSystemSection") && vmAttr.hasChildNodes()) {
                            NodeList os = vmAttr.getChildNodes();
                            for (l = 0; l < os.getLength(); ++l) {
                                Node osdesc = os.item(l);
                                if (!osdesc.getNodeName().equalsIgnoreCase(nsString + "Description") || !osdesc.hasChildNodes()) continue;
                                String desc = osdesc.getFirstChild().getNodeValue();
                                platform = Platform.guess((String)desc);
                                if (!desc.contains("32") && (!desc.contains("x86") || desc.contains("64"))) continue;
                                architecture = Architecture.I32;
                            }
                            continue;
                        }
                        if (!vmAttr.getNodeName().equalsIgnoreCase(nsString + "NetworkConnectionSection") || !vmAttr.hasChildNodes()) continue;
                        tagPair = this.parseNetworkConnectionSection(vmAttr, nsString);
                    }
                }
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase(nsString + "datecreated") && attribute.hasChildNodes()) {
                vCloud cfr_ignored_0 = (vCloud)this.getProvider();
                createdAt = vCloud.parseTime(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!attribute.getNodeName().equalsIgnoreCase(nsString + "LeaseSettingsSection") || !attribute.hasChildNodes()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Checking lease settings for VAppTemplate : " + name));
            }
            children = attribute.getChildNodes();
            for (j = 0; j < children.getLength(); ++j) {
                Calendar cal;
                String expiryDateString;
                Date expiryDate;
                child = children.item(j);
                if (!child.getNodeName().equalsIgnoreCase(nsString + "StorageLeaseExpiration") || !child.hasChildNodes() || (expiryDate = new Date(vCloud.parseTime(expiryDateString = child.getFirstChild().getNodeValue().trim()))) == null || (cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"))).getTimeInMillis() <= expiryDate.getTime()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("vAppTemplate " + name + " has an expired storage lease."));
                }
                return null;
            }
        }
        if (name == null) {
            name = imageId;
        }
        if (description == null) {
            description = name;
        }
        if (platform.equals((Object)Platform.UNKNOWN)) {
            platform = Platform.guess((String)(name + " " + description));
        }
        MachineImage image = MachineImage.getMachineImageInstance((String)ownerId, (String)this.getContext().getRegionId(), (String)imageId, (MachineImageState)MachineImageState.ACTIVE, (String)name, (String)description, (Architecture)architecture, (Platform)platform).createdAt(createdAt);
        StringBuilder ids = new StringBuilder();
        for (String id : childVms) {
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append(id);
        }
        image.setTag("childVirtualMachineIds", ids.toString());
        if (published) {
            image.setTag("public", "true");
        }
        if (tagPair != null) {
            if (tagPair.defaultVlanName != null) {
                image.setTag("defaultVlanName", tagPair.defaultVlanName);
            }
            if (tagPair.defaultVlanNameDHCP != null) {
                image.setTag("defaultVlanNameDHCP", tagPair.defaultVlanNameDHCP);
            }
        }
        return image;
    }

    private TagPair parseNetworkConnectionSection(@Nonnull Node vmAttr, @Nonnull String nsString) {
        int primaryNetIndex = -1;
        NodeList netList = vmAttr.getChildNodes();
        for (int i = 0; i < netList.getLength(); ++i) {
            Node node = netList.item(i);
            if (!node.getNodeName().equalsIgnoreCase(nsString + "PrimaryNetworkConnectionIndex")) continue;
            primaryNetIndex = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
            break;
        }
        String defaultVlanName = null;
        String defaultVlanNameDHCP = null;
        if (primaryNetIndex >= 0) {
            for (int i = 0; i < netList.getLength(); ++i) {
                Node node = netList.item(i);
                if (!node.getNodeName().equalsIgnoreCase(nsString + "NetworkConnection")) continue;
                NodeList netNodeChildren = node.getChildNodes();
                for (int j = 0; j < netNodeChildren.getLength(); ++j) {
                    int thisIndex;
                    Node netNodeChild = netNodeChildren.item(j);
                    if (!netNodeChild.getNodeName().equalsIgnoreCase(nsString + "NetworkConnectionIndex") || primaryNetIndex != (thisIndex = Integer.parseInt(netNodeChild.getFirstChild().getNodeValue().trim()))) continue;
                    NamedNodeMap netNodeChildAttributes = node.getAttributes();
                    Node networkNode = netNodeChildAttributes.getNamedItem("network");
                    String networkName = networkNode.getNodeValue();
                    for (int k = 0; k < netNodeChildren.getLength(); ++k) {
                        Node netNodeChild2 = netNodeChildren.item(k);
                        if (!netNodeChild2.getNodeName().equalsIgnoreCase(nsString + "IpAddressAllocationMode")) continue;
                        if ("DHCP".equalsIgnoreCase(netNodeChild2.getFirstChild().getNodeValue().trim())) {
                            defaultVlanNameDHCP = networkName;
                            continue;
                        }
                        defaultVlanName = networkName;
                    }
                }
            }
        }
        return new TagPair(defaultVlanName, defaultVlanNameDHCP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.remove");
        try {
            MachineImage image = this.getImage(providerImageId);
            if (image == null) {
                throw new CloudException("No such image: " + providerImageId);
            }
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            String catalogItemId = (String)image.getTag("catalogItemId");
            method.delete("vAppTemplate", providerImageId);
            if (catalogItemId != null) {
                method.delete("catalogItem", catalogItemId);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nonnull ImageFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.searchPublicImages");
        try {
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            for (Catalog catalog : this.listPublicCatalogs()) {
                vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
                String xml = method.get("catalog", catalog.catalogId);
                if (xml == null) {
                    logger.warn((Object)("Unable to find catalog " + catalog.catalogId + " indicated by org " + this.getContext().getAccountNumber()));
                    continue;
                }
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                NodeList cNodes = doc.getElementsByTagName(nsString + "Catalog");
                for (int i = 0; i < cNodes.getLength(); ++i) {
                    Node cnode = cNodes.item(i);
                    if (!cnode.hasChildNodes()) continue;
                    NodeList items = cnode.getChildNodes();
                    for (int j = 0; j < items.getLength(); ++j) {
                        Node wrapper = items.item(j);
                        nsString = wrapper.getNodeName().contains(":") ? wrapper.getNodeName().substring(0, wrapper.getNodeName().indexOf(":") + 1) : "";
                        if (!wrapper.getNodeName().equalsIgnoreCase(nsString + "CatalogItems") || !wrapper.hasChildNodes()) continue;
                        NodeList entries = wrapper.getChildNodes();
                        for (int k = 0; k < entries.getLength(); ++k) {
                            String catalogItemId;
                            MachineImage image;
                            Node href;
                            Node item = entries.item(k);
                            nsString = item.getNodeName().contains(":") ? item.getNodeName().substring(0, item.getNodeName().indexOf(":") + 1) : "";
                            if (!item.getNodeName().equalsIgnoreCase(nsString + "CatalogItem") || !item.hasAttributes() || (href = item.getAttributes().getNamedItem("href")) == null || (image = this.loadTemplate(catalog.owner, catalogItemId = ((vCloud)this.getProvider()).toID(href.getNodeValue().trim()), catalog.published)) == null || options != null && !options.matches(image)) continue;
                            image.setProviderOwnerId(catalog.owner);
                            image.setTag("catalogItemId", catalogItemId);
                            images.add(image);
                        }
                    }
                }
            }
            ArrayList<MachineImage> arrayList = images;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean supportsCustomImages() {
        return true;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) {
        return type.equals((Object)MachineImageType.VOLUME);
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) {
        return cls.equals((Object)ImageClass.MACHINE);
    }

    private class TagPair {
        String defaultVlanName;
        String defaultVlanNameDHCP;

        private TagPair(String defaultVlanName, String defaultVlanNameDHCP) {
            this.defaultVlanName = this.nonEmpty(defaultVlanName);
            this.defaultVlanNameDHCP = this.nonEmpty(defaultVlanNameDHCP);
        }

        private String nonEmpty(String input) {
            if (input == null) {
                return null;
            }
            if (input.trim().isEmpty()) {
                return null;
            }
            return input.trim();
        }
    }

    public static class Catalog {
        public String catalogId;
        public String name;
        public boolean published;
        public String owner;
    }
}

