/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.dataprovider.AbstractProviderType;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.junit.Assert;
import org.junit.Test;

public class DataSetDefJsonTest {
    private static final String UTF_8 = "UTF-8";
    private static final String BEAN_DEF_PATH = "beanDataSetDef.dset";
    private static final String FILTER_DEF_PATH = "dataSetDefFilter.dset";
    private static final String EXPENSES_DEF_PATH = "expenseReports.dset";
    private static final String CSV_DEF_PATH = "csvDataSetDef.dset";
    DataSetDefJSONMarshaller jsonMarshaller = new DataSetDefJSONMarshaller(new DataSetProviderRegistry(){

        public void registerDataProvider(DataSetProvider dataProvider) {
        }

        public DataSetProvider getDataSetProvider(DataSetProviderType type) {
            return null;
        }

        public DataSetProviderType getProviderTypeByName(String name) {
            switch (name) {
                case "BEAN": {
                    return DataSetProviderType.BEAN;
                }
                case "CSV": {
                    return DataSetProviderType.CSV;
                }
                case "SQL": {
                    return DataSetProviderType.SQL;
                }
            }
            return null;
        }

        public Set<DataSetProviderType> getAvailableTypes() {
            return new HashSet<AbstractProviderType>(Arrays.asList(DataSetProviderType.BEAN, DataSetProviderType.CSV, DataSetProviderType.SQL));
        }
    });

    @Test
    public void testBean() throws Exception {
        BeanDataSetDef dataSetDef = new BeanDataSetDef();
        dataSetDef.setName("bean data set name");
        dataSetDef.setUUID("bean-test-uuid");
        dataSetDef.setProvider((DataSetProviderType)DataSetProviderType.BEAN);
        dataSetDef.setCacheEnabled(false);
        dataSetDef.setCacheMaxRows(Integer.valueOf(100));
        dataSetDef.setPublic(true);
        dataSetDef.setPushEnabled(false);
        dataSetDef.setPushMaxSize(Integer.valueOf(10));
        dataSetDef.setRefreshAlways(false);
        dataSetDef.setRefreshTime("1second");
        dataSetDef.setGeneratorClass("org.dashbuilder.DataSetGenerator");
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("p1", "v1");
        parameterMap.put("p2", "v2");
        dataSetDef.setParamaterMap(parameterMap);
        String json = this.jsonMarshaller.toJsonString((DataSetDef)dataSetDef);
        String beanJSONContent = DataSetDefJsonTest.getFileAsString(BEAN_DEF_PATH);
        this.assertDataSetDef(json, beanJSONContent);
    }

    @Test
    public void testCSV() throws Exception {
        try {
            String json = DataSetDefJsonTest.getFileAsString(CSV_DEF_PATH);
            CSVDataSetDef def = (CSVDataSetDef)this.jsonMarshaller.fromJson(json);
            Assert.assertEquals((long)def.getColumns().size(), (long)5L);
            DataColumnDef column1 = def.getColumnById("office");
            DataColumnDef column2 = def.getColumnById("department");
            DataColumnDef column3 = def.getColumnById("employee");
            DataColumnDef column4 = def.getColumnById("amount");
            DataColumnDef column5 = def.getColumnById("date");
            Assert.assertNotNull((Object)column1);
            Assert.assertNotNull((Object)column2);
            Assert.assertNotNull((Object)column3);
            Assert.assertNotNull((Object)column4);
            Assert.assertNotNull((Object)column5);
            Assert.assertEquals((Object)column1.getColumnType(), (Object)ColumnType.LABEL);
            Assert.assertEquals((Object)column2.getColumnType(), (Object)ColumnType.LABEL);
            Assert.assertEquals((Object)column3.getColumnType(), (Object)ColumnType.LABEL);
            Assert.assertEquals((Object)column4.getColumnType(), (Object)ColumnType.NUMBER);
            Assert.assertEquals((Object)column5.getColumnType(), (Object)ColumnType.DATE);
            Assert.assertEquals((Object)def.getFilePath(), (Object)"expenseReports.csv");
            Assert.assertNull((Object)def.getFileURL());
            Assert.assertEquals((Object)def.getDatePattern(), (Object)"MM-dd-yyyy");
            Assert.assertEquals((Object)def.getNumberPattern(), (Object)"#,###.##");
            Assert.assertEquals((Object)def.getDatePattern("date"), (Object)"MM-dd-yyyy");
            Assert.assertEquals((Object)def.getNumberPattern("amount"), (Object)"#,###.##");
            Assert.assertEquals((Object)def.getSeparatorChar(), (Object)Character.valueOf(';'));
            Assert.assertEquals((Object)def.getQuoteChar(), (Object)Character.valueOf('\"'));
        }
        catch (ClassCastException e) {
            Assert.fail((String)"Not a CSV dataset def");
        }
    }

    @Test
    public void testColumns() throws Exception {
        String json = DataSetDefJsonTest.getFileAsString(EXPENSES_DEF_PATH);
        DataSetDef def = this.jsonMarshaller.fromJson(json);
        Assert.assertEquals((long)def.getColumns().size(), (long)6L);
        DataColumnDef column1 = def.getColumnById("EXPENSES_ID");
        DataColumnDef column2 = def.getColumnById("DEPARTMENT");
        DataColumnDef column3 = def.getColumnById("AMOUNT");
        DataColumnDef column4 = def.getColumnById("CREATION_DATE");
        DataColumnDef column5 = def.getColumnById("EMPLOYEE");
        DataColumnDef column6 = def.getColumnById("CITY");
        Assert.assertNotNull((Object)column1);
        Assert.assertNotNull((Object)column2);
        Assert.assertNotNull((Object)column3);
        Assert.assertNotNull((Object)column4);
        Assert.assertNotNull((Object)column5);
        Assert.assertNotNull((Object)column6);
        Assert.assertEquals((Object)column1.getColumnType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)column2.getColumnType(), (Object)ColumnType.LABEL);
        Assert.assertEquals((Object)column3.getColumnType(), (Object)ColumnType.NUMBER);
        Assert.assertEquals((Object)column4.getColumnType(), (Object)ColumnType.DATE);
        Assert.assertEquals((Object)column5.getColumnType(), (Object)ColumnType.LABEL);
        Assert.assertEquals((Object)column6.getColumnType(), (Object)ColumnType.LABEL);
    }

    @Test
    public void testFilters() throws Exception {
        BeanDataSetDef dataSetDef = new BeanDataSetDef();
        dataSetDef.setName("filter data set name");
        dataSetDef.setUUID("filter-test-uuid");
        dataSetDef.setProvider((DataSetProviderType)DataSetProviderType.BEAN);
        dataSetDef.setCacheEnabled(false);
        dataSetDef.setCacheMaxRows(Integer.valueOf(100));
        dataSetDef.setPublic(true);
        dataSetDef.setPushEnabled(false);
        dataSetDef.setPushMaxSize(Integer.valueOf(10));
        dataSetDef.setRefreshAlways(false);
        dataSetDef.setRefreshTime("1second");
        dataSetDef.setGeneratorClass("org.dashbuilder.dataprovider.SalesPerYearDataSetGenerator");
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("multiplier", "1");
        dataSetDef.setParamaterMap(parameterMap);
        DataSetFilter filter = new DataSetFilter();
        ArrayList<String> params1 = new ArrayList<String>();
        params1.add("JANUARY");
        CoreFunctionFilter columnFilter = new CoreFunctionFilter("month", CoreFunctionType.EQUALS_TO, params1);
        filter.addFilterColumn(new ColumnFilter[]{columnFilter});
        ArrayList<Double> params2 = new ArrayList<Double>();
        params2.add(0.0);
        params2.add(100.35);
        columnFilter = new CoreFunctionFilter("amount", CoreFunctionType.BETWEEN, params2);
        filter.addFilterColumn(new ColumnFilter[]{columnFilter});
        dataSetDef.setDataSetFilter(filter);
        String json = this.jsonMarshaller.toJsonString((DataSetDef)dataSetDef);
        String filteredDataSetDefJSONContent = DataSetDefJsonTest.getFileAsString(FILTER_DEF_PATH);
        this.assertDataSetDef(json, filteredDataSetDefJSONContent);
    }

    private void assertDataSetDef(String def1, String def2) throws Exception {
        if (def1 == null && def2 != null) {
            Assert.assertTrue((String)"JSON string for Def1 is null and for Def2 is not null", (boolean)false);
        }
        if (def1 != null && def2 == null) {
            Assert.assertTrue((String)"JSON string for Def1 is not null and for Def2 is null", (boolean)false);
        }
        if (def1 == null) {
            Assert.assertTrue((String)"JSON string for both definitions is null", (boolean)false);
        }
        DataSetDef def1Object = this.jsonMarshaller.fromJson(def1);
        DataSetDef def2Object = this.jsonMarshaller.fromJson(def2);
        Assert.assertEquals((Object)def1Object, (Object)def2Object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getFileAsString(String file) throws Exception {
        InputStream mappingsFileUrl = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        String fileContent = null;
        try (StringWriter writer = null;){
            writer = new StringWriter();
            IOUtils.copy((InputStream)mappingsFileUrl, (Writer)writer, (String)UTF_8);
            fileContent = writer.toString();
        }
        return fileContent.replaceAll("\n", "\r\n");
    }
}

