/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.util.Date;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.json.DataSetLookupJSONMarshaller;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.json.JsonBoolean;
import org.dashbuilder.json.JsonNull;
import org.dashbuilder.json.JsonNumber;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonString;
import org.dashbuilder.json.JsonValue;
import org.junit.Assert;
import org.junit.Test;

public class DataSetLookupJsonTest {
    DataSetLookupJSONMarshaller jsonMarshaller = DataSetLookupJSONMarshaller.get();

    @Test
    public void testDataSetLookupMarshalling() {
        DataSetLookup original = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("mydataset")).filter(new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.notEqualsTo((String)"department", (Comparable)((Object)"IT")), FilterFactory.greaterOrEqualsTo((String)"amount", (Comparable)Double.valueOf(100.0))})})).filter("department", new ColumnFilter[]{FilterFactory.notEqualsTo((Comparable)((Object)"IT"))})).filter("amount", new ColumnFilter[]{FilterFactory.between((Comparable)Double.valueOf(100.0), (Comparable)Double.valueOf(200.0))})).filter("date", new ColumnFilter[]{FilterFactory.greaterThan((Comparable)this.jsonMarshaller.parseDate("2018-01-01 00:00:00"))})).filter("country", new ColumnFilter[]{FilterFactory.isNull()})).group("department")).select(new String[]{"Services"})).group("date", "year")).dynamic(DateIntervalType.YEAR, true)).column("date")).column("amount", AggregateFunctionType.SUM, "total")).sort("date", SortOrder.ASCENDING)).buildLookup();
        JsonObject _jsonObj = this.jsonMarshaller.toJson(original);
        Assert.assertNotNull((Object)_jsonObj.toString());
        DataSetLookup unmarshalled = this.jsonMarshaller.fromJson(_jsonObj);
        Assert.assertEquals((Object)unmarshalled, (Object)original);
    }

    @Test
    public void testDateFormat() {
        String d1 = "2020-11-10 23:59:59";
        Date d2 = this.jsonMarshaller.parseDate(d1);
        String d3 = this.jsonMarshaller.formatDate(d2);
        Assert.assertEquals((Object)d1, (Object)d3);
        d1 = "2020-01-01 00:00:00";
        d2 = this.jsonMarshaller.parseDate(d1);
        d3 = this.jsonMarshaller.formatDate(d2);
        Assert.assertEquals((Object)d1, (Object)d3);
    }

    @Test
    public void test_DASHBUILDE_83() {
        JsonValue jsonNull = this.jsonMarshaller.formatValue(null);
        JsonValue jsonBoolean = this.jsonMarshaller.formatValue((Object)true);
        JsonValue jsonNumber = this.jsonMarshaller.formatValue((Object)100.0);
        JsonValue jsonDate = this.jsonMarshaller.formatValue((Object)new Date());
        JsonValue jsonString = this.jsonMarshaller.formatValue((Object)"string");
        Assert.assertTrue((boolean)(jsonNull instanceof JsonNull));
        Assert.assertTrue((boolean)(jsonBoolean instanceof JsonBoolean));
        Assert.assertTrue((boolean)(jsonNumber instanceof JsonNumber));
        Assert.assertTrue((boolean)(jsonDate instanceof JsonString));
        Assert.assertTrue((boolean)(jsonString instanceof JsonString));
    }
}

