/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.backend;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.engine.SharedDataSetOpEngine;
import org.dashbuilder.dataset.engine.index.DataSetIndex;
import org.dashbuilder.dataset.events.DataSetBackendRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetBackendRemovedEvent;

@ApplicationScoped
public class BackendDataSetManager
implements DataSetManager {
    @Inject
    protected SharedDataSetOpEngine dataSetOpEngine;
    @Inject
    private Event<DataSetBackendRegisteredEvent> dataSetRegisteredEvent;
    @Inject
    private Event<DataSetBackendRemovedEvent> dataSetRemovedEvent;

    public DataSet createDataSet(String uuid) {
        DataSet dataSet = DataSetFactory.newDataSet();
        dataSet.setUUID(uuid);
        return dataSet;
    }

    public DataSet getDataSet(String uuid) {
        DataSetIndex index = this.fetchDataSet(uuid);
        if (index == null) {
            return null;
        }
        return index.getDataSet();
    }

    public DataSetMetadata getDataSetMetadata(String uuid) {
        DataSet dataSet = this.getDataSet(uuid);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }

    public void registerDataSet(DataSet dataSet) {
        if (dataSet != null) {
            this.dataSetOpEngine.getIndexRegistry().put(dataSet);
            this.dataSetRegisteredEvent.fire((Object)new DataSetBackendRegisteredEvent(dataSet.getMetadata()));
        }
    }

    public DataSet removeDataSet(String uuid) {
        DataSetIndex index = this.dataSetOpEngine.getIndexRegistry().remove(uuid);
        if (index == null) {
            return null;
        }
        DataSet dataSet = index.getDataSet();
        this.dataSetRemovedEvent.fire((Object)new DataSetBackendRemovedEvent(dataSet.getMetadata()));
        return dataSet;
    }

    public DataSet refreshDataSet(String uuid) {
        this.dataSetOpEngine.getIndexRegistry().remove(uuid);
        DataSetIndex index = this.fetchDataSet(uuid);
        if (index == null) {
            return null;
        }
        return index.getDataSet();
    }

    public DataSet lookupDataSet(DataSetLookup lookup) {
        String uuid = lookup.getDataSetUUID();
        if (StringUtils.isEmpty((String)uuid)) {
            return null;
        }
        DataSetIndex dataSetIndex = this.fetchDataSet(uuid);
        if (dataSetIndex == null) {
            return null;
        }
        DataSet dataSet = dataSetIndex.getDataSet();
        if (!lookup.getOperationList().isEmpty()) {
            dataSet = this.dataSetOpEngine.execute(dataSetIndex.getDataSet(), lookup.getOperationList());
        }
        dataSet = dataSet.trim(lookup.getRowOffset(), lookup.getNumberOfRows());
        return dataSet;
    }

    public DataSet[] lookupDataSets(DataSetLookup[] lookup) {
        DataSet[] result = new DataSet[lookup.length];
        for (int i = 0; i < lookup.length; ++i) {
            result[i] = this.lookupDataSet(lookup[i]);
        }
        return result;
    }

    public DataSetMetadata lookupDataSetMetadata(DataSetLookup lookup) {
        DataSet dataSet = this.lookupDataSet(lookup);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }

    protected DataSetIndex fetchDataSet(String uuid) {
        DataSetIndex index = this.dataSetOpEngine.getIndexRegistry().get(uuid);
        if (index != null) {
            return index;
        }
        return this.loadDataSet(uuid);
    }

    protected DataSetIndex loadDataSet(String uuid) {
        return null;
    }
}

