/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.backend;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.date.Quarter;
import org.dashbuilder.dataset.engine.DataSetHandler;
import org.dashbuilder.dataset.engine.group.Interval;
import org.dashbuilder.dataset.engine.group.IntervalBuilder;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.dataset.sort.SortedList;

@ApplicationScoped
public class BackendIntervalBuilderDynamicDate
implements IntervalBuilder {
    private static SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");

    public IntervalList build(DataSetHandler handler, ColumnGroup columnGroup) {
        Date maxDate;
        IntervalDateRangeList results = new IntervalDateRangeList(columnGroup);
        DataSet dataSet = handler.getDataSet();
        List values = dataSet.getColumnById(columnGroup.getSourceId()).getValues();
        if (values.isEmpty()) {
            return results;
        }
        DataSetSort sortOp = new DataSetSort();
        sortOp.addSortColumn(new ColumnSort[]{new ColumnSort(columnGroup.getSourceId(), SortOrder.ASCENDING)});
        DataSetHandler sortResults = handler.sort(sortOp);
        List sortedRows = sortResults.getRows();
        if (sortedRows == null || sortedRows.isEmpty()) {
            return results;
        }
        SortedList sortedValues = new SortedList(values, sortedRows);
        Date minDate = (Date)sortedValues.get(0);
        if (minDate.compareTo(maxDate = (Date)sortedValues.get(sortedValues.size() - 1)) == 0) {
            IntervalDateRange interval = new IntervalDateRange(DateIntervalType.DAY, minDate, maxDate);
            for (int row = 0; row < sortedValues.size(); ++row) {
                interval.rows.add(row);
            }
            results.add((Object)interval);
            return results;
        }
        int maxIntervals = columnGroup.getMaxIntervals();
        if (maxIntervals < 1) {
            maxIntervals = 15;
        }
        DateIntervalType intervalType = DateIntervalType.YEAR;
        long millis = maxDate.getTime() - minDate.getTime();
        for (DateIntervalType type : DateIntervalType.values()) {
            long nintervals = millis / DateIntervalType.getDurationInMillis((DateIntervalType)type);
            if (nintervals >= (long)maxIntervals) continue;
            intervalType = type;
            break;
        }
        DateIntervalType intervalSize = null;
        if (!StringUtils.isBlank((String)columnGroup.getIntervalSize())) {
            intervalSize = DateIntervalType.getByName((String)columnGroup.getIntervalSize());
        }
        if (intervalSize != null && DateIntervalType.compare((DateIntervalType)intervalType, (DateIntervalType)intervalSize) == -1) {
            intervalType = intervalSize;
        }
        Calendar gc = GregorianCalendar.getInstance();
        gc.setLenient(false);
        gc.setTime(minDate);
        if (DateIntervalType.YEAR.equals((Object)intervalType)) {
            gc.set(2, 0);
            gc.set(5, 1);
            gc.set(10, 0);
            gc.set(12, 0);
            gc.set(13, 0);
            gc.set(14, 0);
        }
        if (DateIntervalType.QUARTER.equals((Object)intervalType)) {
            int currentMonth = gc.get(2);
            int firstMonthYear = columnGroup.getFirstMonthOfYear().getIndex();
            int rest = Quarter.getPositionInQuarter((int)firstMonthYear, (int)currentMonth);
            gc.add(2, rest * -1);
            gc.set(5, 1);
            gc.set(10, 0);
            gc.set(12, 0);
            gc.set(13, 0);
            gc.set(14, 0);
        }
        if (DateIntervalType.MONTH.equals((Object)intervalType)) {
            gc.set(5, 1);
            gc.set(10, 0);
            gc.set(12, 0);
            gc.set(13, 0);
            gc.set(14, 0);
        }
        if (DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType)) {
            gc.set(10, 0);
            gc.set(12, 0);
            gc.set(13, 0);
            gc.set(14, 0);
        }
        if (DateIntervalType.HOUR.equals((Object)intervalType)) {
            gc.set(12, 0);
            gc.set(13, 0);
            gc.set(14, 0);
        }
        if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
            gc.set(13, 0);
            gc.set(14, 0);
        }
        if (DateIntervalType.SECOND.equals((Object)intervalType)) {
            gc.set(14, 0);
        }
        int index = 0;
        while (gc.getTime().compareTo(maxDate) <= 0) {
            Date intervalMinDate = gc.getTime();
            if (DateIntervalType.MILLENIUM.equals((Object)intervalType)) {
                gc.add(1, 1000);
            }
            if (DateIntervalType.CENTURY.equals((Object)intervalType)) {
                gc.add(1, 100);
            }
            if (DateIntervalType.DECADE.equals((Object)intervalType)) {
                gc.add(1, 10);
            }
            if (DateIntervalType.YEAR.equals((Object)intervalType)) {
                gc.add(1, 1);
            }
            if (DateIntervalType.QUARTER.equals((Object)intervalType)) {
                gc.add(2, 3);
            }
            if (DateIntervalType.MONTH.equals((Object)intervalType)) {
                gc.add(2, 1);
            }
            if (DateIntervalType.WEEK.equals((Object)intervalType)) {
                gc.add(5, 7);
            }
            if (DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType)) {
                gc.add(5, 1);
            }
            if (DateIntervalType.HOUR.equals((Object)intervalType)) {
                gc.add(11, 1);
            }
            if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
                gc.add(12, 1);
            }
            if (DateIntervalType.SECOND.equals((Object)intervalType)) {
                gc.add(13, 1);
            }
            Date intervalMaxDate = gc.getTime();
            IntervalDateRange interval = new IntervalDateRange(intervalType, intervalMinDate, intervalMaxDate);
            results.add((Object)interval);
            boolean stop = false;
            while (!stop) {
                if (index >= sortedValues.size()) {
                    stop = true;
                    continue;
                }
                Date dateValue = (Date)sortedValues.get(index);
                Integer row = (Integer)sortedRows.get(index);
                if (dateValue.before(intervalMaxDate)) {
                    interval.rows.add(row);
                    ++index;
                    continue;
                }
                stop = true;
            }
        }
        boolean asc = columnGroup.isAscendingOrder();
        if (!asc) {
            Collections.reverse(results);
        }
        return results;
    }

    public class IntervalDateRange
    extends Interval {
        protected DateIntervalType intervalType;
        protected Date minDate;
        protected Date maxDate;

        public IntervalDateRange(DateIntervalType intervalType, Date minDate, Date maxDate) {
            this.name = this.calculateName(intervalType, minDate);
            this.intervalType = intervalType;
            this.minDate = minDate;
            this.maxDate = maxDate;
        }

        public String calculateName(DateIntervalType intervalType, Date d) {
            Locale l = Locale.getDefault();
            if (DateIntervalType.MILLENIUM.equals((Object)intervalType)) {
                SimpleDateFormat formatYear = new SimpleDateFormat("yyyy", l);
                return formatYear.format(d);
            }
            if (DateIntervalType.CENTURY.equals((Object)intervalType)) {
                SimpleDateFormat formatYear = new SimpleDateFormat("yyyy", l);
                return formatYear.format(d);
            }
            if (DateIntervalType.DECADE.equals((Object)intervalType)) {
                SimpleDateFormat formatYear = new SimpleDateFormat("yyyy", l);
                return formatYear.format(d);
            }
            if (DateIntervalType.YEAR.equals((Object)intervalType)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy", l);
                return format.format(d);
            }
            if (DateIntervalType.QUARTER.equals((Object)intervalType)) {
                SimpleDateFormat format = new SimpleDateFormat("MMM yyyy", l);
                return format.format(d);
            }
            if (DateIntervalType.MONTH.equals((Object)intervalType)) {
                SimpleDateFormat format = new SimpleDateFormat("MMMM yyyy", l);
                return format.format(d);
            }
            if (DateIntervalType.WEEK.equals((Object)intervalType)) {
                return DateFormat.getDateInstance(3, l).format(d);
            }
            if (DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType)) {
                SimpleDateFormat format = new SimpleDateFormat("EEE", l);
                return format.format(d) + " " + DateFormat.getDateInstance(3, l).format(d);
            }
            if (DateIntervalType.HOUR.equals((Object)intervalType)) {
                SimpleDateFormat format = new SimpleDateFormat("HH", l);
                return format.format(d) + "h";
            }
            if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
                SimpleDateFormat format = new SimpleDateFormat("mm", l);
                return format.format(d);
            }
            if (DateIntervalType.SECOND.equals((Object)intervalType)) {
                SimpleDateFormat format = new SimpleDateFormat("ss", l);
                return format.format(d);
            }
            return format.format(d);
        }
    }

    public class IntervalDateRangeList
    extends IntervalList {
        public IntervalDateRangeList(ColumnGroup columnGroup) {
            super(columnGroup);
        }

        public Interval locateInterval(Object value) {
            Date d = (Date)value;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                Interval interval = (Interval)i$.next();
                IntervalDateRange dateRange = (IntervalDateRange)interval;
                if (!d.equals(dateRange.minDate) && (!d.after(dateRange.minDate) || !d.before(dateRange.maxDate))) continue;
                return interval;
            }
            return null;
        }
    }
}

