/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.json;

import org.dashbuilder.json.JsonContext;
import org.dashbuilder.json.JsonType;
import org.dashbuilder.json.JsonValue;
import org.dashbuilder.json.JsonVisitor;

public class JsonNumber
implements JsonValue {
    private double number;

    public JsonNumber(double number) {
        this.number = number;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean asBoolean() {
        return !Double.isNaN(this.getNumber()) && Math.abs(this.getNumber()) != 0.0;
    }

    @Override
    public double asNumber() {
        return this.getNumber();
    }

    @Override
    public String asString() {
        return this.toJson();
    }

    public double getNumber() {
        return this.number;
    }

    @Override
    public JsonType getType() {
        return JsonType.NUMBER;
    }

    @Override
    public void traverse(JsonVisitor visitor, JsonContext ctx) {
        visitor.visit(this.getNumber(), ctx);
    }

    @Override
    public String toJson() {
        String toReturn = String.valueOf(this.number);
        if (toReturn.endsWith(".0")) {
            toReturn = toReturn.substring(0, toReturn.length() - 2);
        }
        return toReturn;
    }
}

