/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.util.ClassUtils;

public class ReferenceIdMapping
extends ReferenceMapping {
    public ReferenceIdMapping(ReferenceMapping refMapping) {
        this.initialize(refMapping.storeMgr, refMapping.type);
        this.datastoreContainer = refMapping.datastoreContainer;
        this.javaTypeMappings = new JavaTypeMapping[refMapping.javaTypeMappings.length];
        System.arraycopy(refMapping.javaTypeMappings, 0, this.javaTypeMappings, 0, this.javaTypeMappings.length);
    }

    public Object getObject(ObjectManager om, Object rs, int[] param) {
        Object value = super.getObject(om, rs, param);
        if (value != null) {
            ApiAdapter api = om.getApiAdapter();
            return api.getIdForObject(value);
        }
        return null;
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value) {
        if (value == null) {
            super.setObject(om, ps, param, null);
            return;
        }
        if (this.mappingStrategy == 1 || this.mappingStrategy == 2) {
            String refString = this.getReferenceStringForObject(om, value);
            this.getJavaTypeMapping()[0].setString(om, ps, param, refString);
            return;
        }
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        int colPos = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            int[] cols = new int[this.javaTypeMappings[i].getNumberOfDatastoreMappings()];
            for (int j = 0; j < cols.length; ++j) {
                cols[j] = param[colPos++];
            }
            Class cls = clr.classForName(this.javaTypeMappings[i].getType());
            AbstractClassMetaData implCmd = om.getMetaDataManager().getMetaDataForClass(cls, clr);
            if (implCmd.getObjectidClass().equals(value.getClass().getName())) {
                Object key;
                if (value instanceof OID) {
                    key = ((OID)value).getKeyValue();
                    if (key instanceof String) {
                        this.javaTypeMappings[i].setString(om, ps, cols, (String)key);
                        continue;
                    }
                    this.javaTypeMappings[i].setObject(om, ps, cols, key);
                    continue;
                }
                if (om.getApiAdapter().isSingleFieldIdentity(value)) {
                    key = om.getApiAdapter().getTargetKeyForSingleFieldIdentity(value);
                    if (key instanceof String) {
                        this.javaTypeMappings[i].setString(om, ps, cols, (String)key);
                        continue;
                    }
                    this.javaTypeMappings[i].setObject(om, ps, cols, key);
                    continue;
                }
                String[] pkMemberNames = implCmd.getPrimaryKeyMemberNames();
                for (int j = 0; j < pkMemberNames.length; ++j) {
                    Object pkMemberValue = ClassUtils.getValueForIdentityField(value, pkMemberNames[j]);
                    if (pkMemberValue instanceof Byte) {
                        this.getDatastoreMapping(j).setByte(ps, param[j], (Byte)pkMemberValue);
                        continue;
                    }
                    if (pkMemberValue instanceof Character) {
                        this.getDatastoreMapping(j).setChar(ps, param[j], ((Character)pkMemberValue).charValue());
                        continue;
                    }
                    if (pkMemberValue instanceof Integer) {
                        this.getDatastoreMapping(j).setInt(ps, param[j], (Integer)pkMemberValue);
                        continue;
                    }
                    if (pkMemberValue instanceof Long) {
                        this.getDatastoreMapping(j).setLong(ps, param[j], (Long)pkMemberValue);
                        continue;
                    }
                    if (pkMemberValue instanceof Short) {
                        this.getDatastoreMapping(j).setShort(ps, param[j], (Short)pkMemberValue);
                        continue;
                    }
                    if (pkMemberValue instanceof String) {
                        this.getDatastoreMapping(j).setString(ps, param[j], (String)pkMemberValue);
                        continue;
                    }
                    this.getDatastoreMapping(j).setObject(ps, param[j], pkMemberValue);
                }
                continue;
            }
            this.javaTypeMappings[i].setObject(om, ps, cols, null);
        }
    }
}

