/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Iterator;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.exceptions.ClassDefinitionException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.mapped.scostore.MapKeySetStore;
import org.datanucleus.store.mapped.scostore.MapValueSetStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.ClassUtils;

public abstract class FKMapStore
extends AbstractMapStore {
    private final int ownerFieldNumber;
    protected final ClassLoaderResolver clr;
    protected int keyFieldNumber = -1;
    private int valueFieldNumber = -1;
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;

    public FKMapStore(AbstractMemberMetaData fmd, MappedStoreManager storeMgr, ClassLoaderResolver clr, AbstractMapStoreSpecialization specialization) {
        super(storeMgr, specialization);
        this.clr = clr;
        this.setOwner(fmd, clr);
        MapMetaData mmd = (MapMetaData)fmd.getContainer();
        if (mmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056002", (Object)fmd.getFullFieldName()));
        }
        boolean keyStoredInValue = false;
        if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
            keyStoredInValue = true;
        } else if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() == null) {
            throw new NucleusUserException(LOCALISER.msg("056071", (Object)fmd.getFullFieldName()));
        }
        this.keyType = mmd.getKeyType();
        this.valueType = mmd.getValueType();
        Class keyClass = clr.classForName(this.keyType);
        Class valueClass = clr.classForName(this.valueType);
        ApiAdapter api = ((AbstractStoreManager)this.getStoreManager()).getApiAdapter();
        if (keyStoredInValue && !api.isPersistable(valueClass)) {
            throw new NucleusUserException(LOCALISER.msg("056072", (Object)fmd.getFullFieldName(), (Object)this.valueType));
        }
        if (!keyStoredInValue && !api.isPersistable(keyClass)) {
            throw new NucleusUserException(LOCALISER.msg("056073", (Object)fmd.getFullFieldName(), (Object)this.keyType));
        }
        String ownerFieldName = fmd.getMappedBy();
        if (keyStoredInValue) {
            this.vmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(valueClass, clr);
            if (this.vmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056070", (Object)this.valueType, (Object)fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.valueType, clr);
            this.valueMapping = storeMgr.getDatastoreClass(this.valueType, clr).getIdMapping();
            this.valuesAreEmbedded = false;
            this.valuesAreSerialised = false;
            if (fmd.getMappedBy() != null) {
                AbstractMemberMetaData vofmd = this.vmd.getMetaDataForMember(ownerFieldName);
                if (vofmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("056067", (Object)fmd.getFullFieldName(), (Object)ownerFieldName, (Object)valueClass.getName()));
                }
                if (!clr.isAssignableFrom(vofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                    throw new NucleusUserException(LOCALISER.msg("056068", (Object)fmd.getFullFieldName(), (Object)vofmd.getFullFieldName(), (Object)vofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.vmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getMemberMapping(vofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType, (Object)ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("056055", (Object)ownerFieldName, (Object)this.valueType, (Object)vofmd.getTypeName(), (Object)fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("056056", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((fmd.getKeyMetaData() == null || fmd.getKeyMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056050", (Object)valueClass.getName()));
            }
            String key_field_name = fmd.getKeyMetaData().getMappedBy();
            if (key_field_name != null && (vkfmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForMember(valueClass, clr, key_field_name)) == null) {
                throw new NucleusUserException(LOCALISER.msg("056052", (Object)valueClass.getName(), (Object)key_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("056050", (Object)fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible(vkfmd.getType(), this.keyType, clr)) {
                throw new NucleusUserException(LOCALISER.msg("056051", (Object)fmd.getFullFieldName(), (Object)this.keyType, (Object)vkfmd.getType().getName()));
            }
            String keyFieldName = vkfmd.getName();
            this.keyFieldNumber = this.vmd.getAbsolutePositionOfMember(keyFieldName);
            this.keyMapping = this.valueTable.getMemberMapping(this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(this.keyFieldNumber));
            if (this.keyMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056053", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType, (Object)keyFieldName));
            }
            if (!this.keyMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map key field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.keysAreEmbedded = this.isEmbeddedMapping(this.keyMapping);
            this.keysAreSerialised = this.isEmbeddedMapping(this.keyMapping);
            this.mapTable = this.valueTable;
            if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.mapTable) {
                this.mapTable = this.ownerMapping.getDatastoreContainer();
            }
        } else {
            this.kmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(keyClass, clr);
            if (this.kmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056069", (Object)this.keyType, (Object)fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.keyType, clr);
            this.keyMapping = storeMgr.getDatastoreClass(this.keyType, clr).getIdMapping();
            this.keysAreEmbedded = false;
            this.keysAreSerialised = false;
            if (fmd.getMappedBy() != null) {
                AbstractMemberMetaData kofmd = this.kmd.getMetaDataForMember(ownerFieldName);
                if (kofmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("056067", (Object)fmd.getFullFieldName(), (Object)ownerFieldName, (Object)keyClass.getName()));
                }
                if (!ClassUtils.typesAreCompatible(kofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName(), clr)) {
                    throw new NucleusUserException(LOCALISER.msg("056068", (Object)fmd.getFullFieldName(), (Object)kofmd.getFullFieldName(), (Object)kofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.kmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getMemberMapping(kofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType, (Object)ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("056055", (Object)ownerFieldName, (Object)this.keyType, (Object)kofmd.getTypeName(), (Object)fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("056056", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((fmd.getValueMetaData() == null || fmd.getValueMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056057", (Object)keyClass.getName()));
            }
            String value_field_name = fmd.getValueMetaData().getMappedBy();
            if (value_field_name != null && (vkfmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForMember(keyClass, clr, value_field_name)) == null) {
                throw new NucleusUserException(LOCALISER.msg("056059", (Object)keyClass.getName(), (Object)value_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("056057", (Object)fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible(vkfmd.getType(), this.valueType, clr)) {
                throw new NucleusUserException(LOCALISER.msg("056058", (Object)fmd.getFullFieldName(), (Object)this.valueType, (Object)vkfmd.getType().getName()));
            }
            String valueFieldName = vkfmd.getName();
            this.valueFieldNumber = this.kmd.getAbsolutePositionOfMember(valueFieldName);
            this.valueMapping = this.valueTable.getMemberMapping(this.kmd.getMetaDataForManagedMemberAtAbsolutePosition(this.valueFieldNumber));
            if (this.valueMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056054", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType, (Object)valueFieldName));
            }
            if (!this.valueMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map value field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.valuesAreEmbedded = this.isEmbeddedMapping(this.valueMapping);
            this.valuesAreSerialised = this.isEmbeddedMapping(this.valueMapping);
            this.mapTable = this.valueTable;
            if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.mapTable) {
                this.mapTable = this.ownerMapping.getDatastoreContainer();
            }
        }
        specialization.initialise(this);
        this.initialise();
    }

    protected abstract void initialise();

    protected abstract boolean updateKeyFkInternal(StateManager var1, Object var2, Object var3);

    protected abstract boolean updateValueFkInternal(StateManager var1, Object var2, Object var3);

    protected abstract MapKeySetStore newMapKeySetStore();

    protected abstract MapValueSetStore newMapValueSetStore();

    protected abstract MapEntrySetStore newMapEntrySetStore();

    private boolean updateValueFk(StateManager sm, Object value, Object owner) {
        if (value == null) {
            return false;
        }
        this.validateValueForWriting(sm, value);
        return this.updateValueFkInternal(sm, value, owner);
    }

    private boolean updateKeyFk(StateManager sm, Object key, Object owner) {
        if (key == null) {
            return false;
        }
        this.validateKeyForWriting(sm, key);
        return this.updateKeyFkInternal(sm, key, owner);
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value == null) {
            throw new NullPointerException(LOCALISER.msg("056063"));
        }
        super.validateValueType(clr, value);
    }

    public Object put(StateManager sm, final Object newKey, Object newValue) {
        if (this.keyFieldNumber >= 0) {
            this.validateKeyForWriting(sm, newKey);
            this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), newValue);
        } else {
            this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), newKey);
            this.validateValueForWriting(sm, newValue);
        }
        Object oldValue = this.get(sm, newKey);
        if (oldValue != newValue) {
            if (this.vmd != null) {
                if (oldValue != null && !oldValue.equals(newValue)) {
                    this.removeValue(sm, newKey, oldValue);
                }
                ObjectManager om = sm.getObjectManager();
                final Object newOwner = sm.getObject();
                if (om.getApiAdapter().isPersistent(newValue)) {
                    PersistenceCapable newValuePC = (PersistenceCapable)newValue;
                    if (om != om.getApiAdapter().getObjectManager(newValue)) {
                        throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteValudInvalidWithDifferentPM"), newValuePC.jdoGetObjectId());
                    }
                    StateManager vsm = om.findStateManager(newValue);
                    if (this.ownerFieldNumber >= 0) {
                        om.getApiAdapter().isLoaded(vsm, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.setObjectField(newValuePC, this.ownerFieldNumber, oldOwner, newOwner);
                    } else {
                        this.updateValueFk(sm, newValue, newOwner);
                    }
                    om.getApiAdapter().isLoaded(vsm, this.keyFieldNumber);
                    Object oldKey = vsm.provideField(this.keyFieldNumber);
                    vsm.setObjectField(newValuePC, this.keyFieldNumber, oldKey, newKey);
                } else {
                    om.persistObjectInternal(newValue, new FieldValues(){

                        public void fetchFields(StateManager vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceField(FKMapStore.this.ownerFieldNumber, newOwner, true);
                            }
                            vsm.replaceField(FKMapStore.this.keyFieldNumber, newKey, true);
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, null, -1, 0);
                    if (this.ownerFieldNumber < 0) {
                        this.updateValueFk(sm, newValue, newOwner);
                    }
                }
            } else {
                ObjectManager om = sm.getObjectManager();
                PersistenceCapable pcNewKey = (PersistenceCapable)newKey;
                final Object newOwner = sm.getObject();
                if (om.getApiAdapter().isPersistent(pcNewKey)) {
                    if (om != om.getApiAdapter().getObjectManager(pcNewKey)) {
                        throw new NucleusUserException(LOCALISER.msg("056060"), om.getApiAdapter().getIdForObject(pcNewKey));
                    }
                    StateManager vsm = om.findStateManager(pcNewKey);
                    if (this.ownerFieldNumber >= 0) {
                        om.getApiAdapter().isLoaded(vsm, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.setObjectField(pcNewKey, this.ownerFieldNumber, oldOwner, newOwner);
                    } else {
                        this.updateKeyFk(sm, pcNewKey, newOwner);
                    }
                    om.getApiAdapter().isLoaded(vsm, this.valueFieldNumber);
                    oldValue = vsm.provideField(this.valueFieldNumber);
                    vsm.setObjectField(pcNewKey, this.valueFieldNumber, oldValue, newValue);
                } else {
                    final Object newValueObj = newValue;
                    om.persistObjectInternal(newKey, new FieldValues(){

                        public void fetchFields(StateManager vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceField(FKMapStore.this.ownerFieldNumber, newOwner, true);
                            }
                            vsm.replaceField(FKMapStore.this.valueFieldNumber, newValueObj, true);
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, null, -1, 0);
                    if (this.ownerFieldNumber < 0) {
                        this.updateKeyFk(sm, pcNewKey, newOwner);
                    }
                }
            }
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getObjectManager().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public Object remove(StateManager sm, Object key) {
        Object oldValue = this.get(sm, key);
        if (this.keyFieldNumber >= 0) {
            if (oldValue != null) {
                this.removeValue(sm, key, oldValue);
                sm.getObjectManager().flushInternal(false);
            }
        } else {
            sm.getObjectManager().deleteObjectInternal(key);
        }
        if (this.ownerMemberMetaData.getMap().isDependentKey()) {
            sm.getObjectManager().deleteObjectInternal(key);
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue()) {
            sm.getObjectManager().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    private void removeValue(StateManager sm, Object key, Object oldValue) {
        ObjectManager om = sm.getObjectManager();
        if (this.keyMapping.isNullable()) {
            PersistenceCapable pcOldValue = (PersistenceCapable)oldValue;
            StateManager vsm = om.findStateManager(pcOldValue);
            vsm.setObjectField(pcOldValue, this.keyFieldNumber, key, null);
            vsm.replaceField(this.keyFieldNumber, null, true);
            if (this.ownerFieldNumber >= 0) {
                Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                vsm.setObjectField(pcOldValue, this.ownerFieldNumber, oldOwner, null);
                vsm.replaceField(this.ownerFieldNumber, null, true);
            } else {
                this.updateValueFk(sm, pcOldValue, null);
            }
        } else {
            om.deleteObjectInternal(oldValue);
        }
    }

    public void clear(StateManager sm) {
        Iterator iter = this.keySetStore().iterator(sm);
        while (iter.hasNext()) {
            this.remove(sm, iter.next());
        }
    }

    public void clearKeyOfValue(StateManager sm, Object key, Object oldValue) {
        ObjectManager om = sm.getObjectManager();
        if (this.keyMapping.isNullable()) {
            StateManager vsm = om.findStateManager(oldValue);
            PersistenceCapable oldValuePC = (PersistenceCapable)oldValue;
            if (!om.getApiAdapter().isDeleted(oldValuePC)) {
                vsm.setObjectField(oldValuePC, this.keyFieldNumber, key, null);
                vsm.replaceField(this.keyFieldNumber, null, true);
                vsm.makeDirty(this.keyFieldNumber);
            }
        } else {
            om.deleteObjectInternal(oldValue);
        }
    }

    public synchronized SetStore keySetStore() {
        return this.keySetStore == null ? this.newMapKeySetStore() : this.keySetStore;
    }

    public synchronized SetStore valueSetStore() {
        return this.valueSetStore == null ? this.newMapValueSetStore() : this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        return this.entrySetStore == null ? this.newMapEntrySetStore() : this.entrySetStore;
    }

    public ScalarExpression joinKeysTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier mapTableAlias, Class filteredKeyType, ScalarExpression kExpr, DatastoreIdentifier keyTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.keyType, filteredKeyType) && !clr.isAssignableFrom(filteredKeyType, this.keyType)) {
            throw new IncompatibleQueryElementTypeException(this.keyType, filteredKeyType.getName());
        }
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, te);
        DatastoreIdentifier containerRangeVar = mapTableAlias;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = keyTableAlias;
        }
        stmt.newTableExpression(this.mapTable, containerRangeVar);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (!this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredKeyType.getName())) {
            DatastoreClass filteredKeyTable = this.storeMgr.getDatastoreClass(filteredKeyType.getName(), stmt.getClassLoaderResolver());
            JavaTypeMapping keyTableID = filteredKeyTable.getIdMapping();
            stmt.newTableExpression(filteredKeyTable, keyTableAlias);
            ScalarExpression keyMapExpr = this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            ScalarExpression keyExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyTableAlias));
            stmt.innerJoin(keyExpr, keyMapExpr, stmt.getTableExpression(keyTableAlias), true, true);
            return keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyTableAlias));
        }
        return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    public ScalarExpression joinValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredValueType, ScalarExpression valExpr, DatastoreIdentifier valueRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.valueType, filteredValueType) && !clr.isAssignableFrom(filteredValueType, this.valueType)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, filteredValueType.getName());
        }
        DatastoreClass filteredValueTable = this.storeMgr.getDatastoreClass(filteredValueType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredValueTable, valueRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = mapRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = valueRangeVar;
        }
        ScalarExpression ownerValueExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.valueTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerValueExpr), true);
        JavaTypeMapping valueTableID = filteredValueTable.getIdMapping();
        return valueTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    public ScalarExpression[] joinKeysValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredKeyType, Class filteredValueType, ScalarExpression keyExpr, ScalarExpression valExpr, DatastoreIdentifier keyRangeVar, DatastoreIdentifier valueRangeVar) {
        ScalarExpression[] qclKeyValues = new ScalarExpression[]{this.joinKeysTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredKeyType, keyExpr, keyRangeVar), this.joinValuesTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredValueType, valExpr, valueRangeVar)};
        return qclKeyValues;
    }
}

