/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neodatis;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.neodatis.NeoDatisPersistenceHandler;
import org.datanucleus.store.neodatis.NeoDatisStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBFactory;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.ODBServer;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    protected static final Localiser LOCALISER_NEODATIS = Localiser.getInstance((String)"org.datanucleus.store.neodatis.Localisation", (ClassLoader)(class$org$datanucleus$store$neodatis$NeoDatisStoreManager == null ? (class$org$datanucleus$store$neodatis$NeoDatisStoreManager = ConnectionFactoryImpl.class$("org.datanucleus.store.neodatis.NeoDatisStoreManager")) : class$org$datanucleus$store$neodatis$NeoDatisStoreManager).getClassLoader());
    private boolean neodatisUseEmbeddedServer = false;
    private ODBServer neodatisEmbeddedServer = null;
    private String neodatisFilename = null;
    private String neodatisHostname = null;
    private int neodatisPort = 0;
    private String neodatisIdentifier = null;
    protected HashMap odbByObjectManager = new HashMap();
    static /* synthetic */ Class class$org$datanucleus$store$neodatis$NeoDatisStoreManager;

    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        super(omfContext, resourceType);
        String url = omfContext.getStoreManager().getConnectionURL();
        if (!url.startsWith("neodatis")) {
            throw new NucleusException(LOCALISER_NEODATIS.msg("NeoDatis.URLInvalid", (Object)url));
        }
        String neodatisStr = url.substring(9);
        if (neodatisStr.indexOf("server:") < 0 && neodatisStr.indexOf("file:") < 0) {
            this.neodatisHostname = neodatisStr.substring(0, neodatisStr.indexOf(58));
            try {
                String str;
                String portName = str = neodatisStr.substring(neodatisStr.indexOf(58) + 1);
                if (str.indexOf("/") > 0) {
                    portName = str.substring(0, str.indexOf("/"));
                    this.neodatisIdentifier = str.substring(str.indexOf("/") + 1);
                }
                this.neodatisPort = new Integer(portName);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusUserException(LOCALISER_NEODATIS.msg("NeoDatis.URLInvalid", (Object)url));
            }
        }
        String filename = neodatisStr.substring(neodatisStr.indexOf(58) + 1);
        try {
            this.neodatisFilename = new File(new URL(neodatisStr).toURI()).getAbsolutePath();
        }
        catch (Exception e) {
            try {
                String absFilename = System.getProperty("user.dir") + System.getProperty("file.separator") + filename;
                File file = new File(absFilename);
                NucleusLogger.DATASTORE.info((Object)LOCALISER_NEODATIS.msg("NeoDatis.FilestoreRelativePath", (Object)neodatisStr, (Object)absFilename));
                this.neodatisFilename = file.getAbsolutePath();
            }
            catch (Exception e2) {
                throw new NucleusUserException(LOCALISER_NEODATIS.msg("NeoDatis.FilenameError", (Object)this.neodatisFilename, (Object)e.getMessage()), (Throwable)e);
            }
        }
        this.neodatisUseEmbeddedServer = neodatisStr.startsWith("server:");
    }

    public void closeODBForObjectManager(Object poolKey) {
        Object obj = this.odbByObjectManager.get(poolKey);
        if (obj != null) {
            ODB odb = (ODB)obj;
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.ClosingConnection", (Object)this.omfContext.getStoreManager().getConnectionURL(), (Object)StringUtils.toJVMIDString((Object)odb)));
            }
            try {
                odb.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.odbByObjectManager.remove(poolKey);
        }
        if (this.odbByObjectManager.isEmpty() && this.neodatisEmbeddedServer != null) {
            try {
                this.neodatisEmbeddedServer.close();
                this.neodatisEmbeddedServer = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ODB getNewODB() {
        odb = null;
        if (this.neodatisFilename != null) {
            try {
                if (this.neodatisUseEmbeddedServer) {
                    if (this.neodatisEmbeddedServer == null) {
                        this.neodatisEmbeddedServer = ODBFactory.openServer((int)10001);
                    }
                    odb = this.neodatisEmbeddedServer.openClient(this.neodatisFilename);
                } else {
                    username = this.omfContext.getStoreManager().getConnectionUserName();
                    odb = username != null ? ODBFactory.open((String)this.neodatisFilename, (String)username, (String)this.omfContext.getStoreManager().getConnectionPassword()) : ODBFactory.open((String)this.neodatisFilename);
                }
                if (!NucleusLogger.DATASTORE.isDebugEnabled()) ** GOTO lbl23
                NucleusLogger.DATASTORE.debug((Object)ConnectionFactoryImpl.LOCALISER_NEODATIS.msg("NeoDatis.OpeningConnection", (Object)this.omfContext.getStoreManager().getConnectionURL(), (Object)StringUtils.toJVMIDString((Object)odb)));
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(ConnectionFactoryImpl.LOCALISER_NEODATIS.msg("NeoDatis.ConnectionError", (Object)this.omfContext.getStoreManager().getConnectionURL()), (Throwable)e);
            }
        } else {
            try {
                odb = ODBFactory.openClient((String)this.neodatisHostname, (int)this.neodatisPort, (String)this.neodatisIdentifier, (String)this.omfContext.getStoreManager().getConnectionUserName(), (String)this.omfContext.getStoreManager().getConnectionPassword());
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE.debug((Object)ConnectionFactoryImpl.LOCALISER_NEODATIS.msg("NeoDatis.OpeningConnection", (Object)this.omfContext.getStoreManager().getConnectionURL(), (Object)StringUtils.toJVMIDString((Object)odb)));
                }
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(ConnectionFactoryImpl.LOCALISER_NEODATIS.msg("NeoDatis.ConnectionError", (Object)this.omfContext.getStoreManager().getConnectionURL()), (Throwable)e);
            }
        }
lbl23:
        // 3 sources

        if (NeoDatisPersistenceHandler.neodatisDebug) {
            System.out.println("ODBFactory.open returns " + StringUtils.toJVMIDString((Object)odb));
        }
        return odb;
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map options) {
        return new ManagedConnectionImpl(poolKey, options);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EmulatedXAResource
    implements XAResource {
        ODB odb;

        EmulatedXAResource(ODB conn) {
            this.odb = conn;
        }

        public void commit(Xid arg0, boolean arg1) throws XAException {
            try {
                if (NeoDatisPersistenceHandler.neodatisDebug) {
                    System.out.println("odb.commit " + StringUtils.toJVMIDString((Object)this.odb));
                }
                this.odb.commit();
            }
            catch (ODBRuntimeException re) {
                throw new XAException("Exception thrown when committing " + re.getMessage());
            }
        }

        public void end(Xid arg0, int arg1) throws XAException {
        }

        public void forget(Xid arg0) throws XAException {
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean isSameRM(XAResource arg0) throws XAException {
            return arg0 instanceof EmulatedXAResource && this.odb.equals(((EmulatedXAResource)arg0).odb);
        }

        public int prepare(Xid arg0) throws XAException {
            return 0;
        }

        public Xid[] recover(int arg0) throws XAException {
            throw new XAException("Unsupported operation");
        }

        public void rollback(Xid arg0) throws XAException {
            try {
                if (NeoDatisPersistenceHandler.neodatisDebug) {
                    System.out.println("odb.rollback " + StringUtils.toJVMIDString((Object)this.odb));
                }
                this.odb.rollback();
            }
            catch (ODBRuntimeException re) {
                throw new XAException("Exception thrown when rolling back " + re.getMessage());
            }
        }

        public boolean setTransactionTimeout(int arg0) throws XAException {
            return false;
        }

        public void start(Xid arg0, int arg1) throws XAException {
        }
    }

    class ManagedConnectionImpl
    extends AbstractManagedConnection {
        Object poolKey = null;

        ManagedConnectionImpl(Object poolKey, Map transactionOptions) {
            this.poolKey = poolKey;
        }

        public XAResource getXAResource() {
            ODB odb = (ODB)this.getConnection();
            return new EmulatedXAResource(odb);
        }

        public Object getConnection() {
            if (this.conn == null) {
                Object objCont;
                if (this.poolKey != null && (objCont = ConnectionFactoryImpl.this.odbByObjectManager.get(this.poolKey)) != null) {
                    this.conn = objCont;
                    return this.conn;
                }
                this.conn = ConnectionFactoryImpl.this.getNewODB();
                if (this.poolKey != null) {
                    ConnectionFactoryImpl.this.odbByObjectManager.put(this.poolKey, this.conn);
                    ((NeoDatisStoreManager)ConnectionFactoryImpl.this.omfContext.getStoreManager()).registerODB((ODB)this.conn);
                }
            }
            return this.conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            int i;
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            try {
                if (this.conn != null) {
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.CommittingConnection", (Object)ConnectionFactoryImpl.this.omfContext.getStoreManager().getConnectionURL(), (Object)StringUtils.toJVMIDString((Object)this.conn)));
                    }
                    if (NeoDatisPersistenceHandler.neodatisDebug) {
                        System.out.println("odb.commit " + StringUtils.toJVMIDString((Object)this.conn));
                    }
                    ((ODB)this.conn).commit();
                    if (this.poolKey != null) {
                        ((NeoDatisStoreManager)ConnectionFactoryImpl.this.omfContext.getStoreManager()).deregisterODB((ODB)this.conn);
                    }
                    if (NeoDatisPersistenceHandler.neodatisDebug) {
                        System.out.println("odb.close " + StringUtils.toJVMIDString((Object)this.conn));
                    }
                    ((ODB)this.conn).close();
                    this.conn = null;
                    if (this.poolKey != null) {
                        ConnectionFactoryImpl.this.odbByObjectManager.remove(this.poolKey);
                    }
                }
            }
            catch (ODBRuntimeException re) {
                throw new NucleusDataStoreException("Exception thrown during close of ManagedConnection", (Throwable)re);
            }
            try {
                for (i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
            finally {
                this.listeners.clear();
            }
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)("The connection has been closed : " + (Object)((Object)this)));
            }
        }
    }
}

