/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neodatis;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractExtent;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.neodatis.NeoDatisStoreManager;
import org.datanucleus.store.neodatis.NeoDatisUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.neodatis.odb.ODB;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;

public class NeoDatisExtent
extends AbstractExtent {
    protected static final Localiser LOCALISER_NEODATIS = Localiser.getInstance((String)"org.datanucleus.store.neodatis.Localisation", (ClassLoader)(class$org$datanucleus$store$neodatis$NeoDatisStoreManager == null ? (class$org$datanucleus$store$neodatis$NeoDatisStoreManager = NeoDatisExtent.class$("org.datanucleus.store.neodatis.NeoDatisStoreManager")) : class$org$datanucleus$store$neodatis$NeoDatisStoreManager).getClassLoader());
    private Set iterators = new HashSet();
    private FetchPlan fetchPlan = null;
    static /* synthetic */ Class class$org$datanucleus$store$neodatis$NeoDatisStoreManager;

    public NeoDatisExtent(ObjectManager om, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        super(om, cls, subclasses, cmd);
        this.fetchPlan = om.getFetchPlan().getCopy();
    }

    public void close(Iterator iter) {
        this.iterators.remove(iter);
    }

    public void closeAll() {
        this.iterators.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        ManagedConnection mconn = this.storeMgr.getConnection(this.om);
        ODB odb = (ODB)mconn.getConnection();
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.Extent.Execute", (Object)this.candidateClass, (Object)("" + this.subclasses)));
            }
            Objects results = null;
            CriteriaQuery query = new CriteriaQuery(this.candidateClass);
            query.setPolymorphic(this.subclasses);
            try {
                results = odb.getObjects((IQuery)query);
            }
            catch (Exception e) {
                throw new NucleusException("Exception thrown executing query", (Throwable)e);
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_NEODATIS.msg("NeoDatis.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            NeoDatisExtentIterator iter = new NeoDatisExtentIterator(results);
            this.iterators.add(iter);
            NeoDatisExtentIterator neoDatisExtentIterator = iter;
            return neoDatisExtentIterator;
        }
        finally {
            mconn.release();
        }
    }

    public FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class NeoDatisExtentIterator
    implements Iterator {
        Objects objects = null;

        public NeoDatisExtentIterator(Objects objects) {
            this.objects = objects;
        }

        public boolean hasNext() {
            return this.objects.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Object obj = this.objects.next();
            ManagedConnection mconn = NeoDatisExtent.this.storeMgr.getConnection(NeoDatisExtent.this.om);
            ODB odb = (ODB)mconn.getConnection();
            try {
                NeoDatisUtils.prepareNeoDatisObjectForUse(obj, NeoDatisExtent.this.om, odb, NeoDatisExtent.this.cmd, (NeoDatisStoreManager)NeoDatisExtent.this.om.getStoreManager());
            }
            finally {
                mconn.release();
            }
            return obj;
        }

        public void remove() {
            throw new UnsupportedOperationException(LOCALISER_NEODATIS.msg("NeoDatis.Extent.IteratorRemoveNotSupported"));
        }
    }
}

