/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neodatis;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreUniqueOID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.PersistFieldManager;
import org.datanucleus.store.neodatis.NeoDatisStoreManager;
import org.datanucleus.store.neodatis.NeoDatisUtils;
import org.datanucleus.store.neodatis.fieldmanager.RetrieveFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.criteria.And;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.impl.core.oid.OdbObjectOID;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;

public class NeoDatisPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.neodatis.Localisation", (ClassLoader)(class$org$datanucleus$store$neodatis$NeoDatisStoreManager == null ? (class$org$datanucleus$store$neodatis$NeoDatisStoreManager = NeoDatisPersistenceHandler.class$("org.datanucleus.store.neodatis.NeoDatisStoreManager")) : class$org$datanucleus$store$neodatis$NeoDatisStoreManager).getClassLoader());
    protected final NeoDatisStoreManager storeMgr;
    public static boolean neodatisDebug = false;
    private ThreadLocal insertInfoThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new OperationInfo();
        }
    };
    static /* synthetic */ Class class$org$datanucleus$store$neodatis$NeoDatisStoreManager;

    public NeoDatisPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (NeoDatisStoreManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(StateManager sm) {
        String className;
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (sm.getClassMetaData().getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("NeoDatis.Insert.ObjectWithIdAlreadyExists", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        if (!this.storeMgr.managesClass(className = sm.getObject().getClass().getName())) {
            this.storeMgr.addClass(className, sm.getObjectManager().getClassLoaderResolver());
        }
        OperationInfo insertInfo = (OperationInfo)this.insertInfoThreadLocal.get();
        boolean primaryObject = false;
        if (insertInfo.objectsList == null) {
            primaryObject = true;
            insertInfo.objectsList = new ArrayList();
        }
        insertInfo.objectsList.add(sm.getObject());
        sm.provideFields(sm.getClassMetaData().getAllMemberPositions(), (FieldManager)new PersistFieldManager(sm, false));
        if (primaryObject) {
            ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
            try {
                ODB odb = (ODB)mconn.getConnection();
                long startTime = 0L;
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.Insert.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
                }
                if (neodatisDebug) {
                    System.out.println(">> insertObject odb.store(" + StringUtils.toJVMIDString((Object)sm.getObject()) + ")");
                }
                odb.store(sm.getObject());
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.ExecutionTime", System.currentTimeMillis() - startTime));
                }
                Iterator objsIter = insertInfo.objectsList.iterator();
                while (objsIter.hasNext()) {
                    Object pc = objsIter.next();
                    this.processInsertedObject(odb, sm.getObjectManager(), pc);
                }
            }
            catch (ODBRuntimeException re) {
                throw new NucleusDataStoreException("Exception throw inserting " + StringUtils.toJVMIDString((Object)sm.getObject()) + " (and reachables) in datastore", (Throwable)re);
            }
            finally {
                mconn.release();
            }
            insertInfo.objectsList.clear();
            insertInfo.objectsList = null;
            this.insertInfoThreadLocal.remove();
        }
    }

    private void processInsertedObject(ODB odb, ObjectManager om, Object pc) {
        StateManager objSM;
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementInsertCount();
        }
        if ((objSM = om.findStateManager(pc)) != null) {
            AbstractClassMetaData cmd = objSM.getClassMetaData();
            OID oid = null;
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                long datastoreId;
                if (neodatisDebug) {
                    System.out.println(">> insertObject odb.getObjectId(" + StringUtils.toJVMIDString((Object)pc) + ")");
                }
                if ((datastoreId = (oid = odb.getObjectId(pc)).getObjectId()) > 0L) {
                    objSM.setPostStoreNewObjectId((Object)OIDFactory.getInstance((OMFContext)om.getOMFContext(), (long)datastoreId));
                } else {
                    String msg = LOCALISER.msg("NeoDatis.Insert.ObjectPersistFailed", (Object)StringUtils.toJVMIDString((Object)pc));
                    NucleusLogger.DATASTORE.error((Object)msg);
                    throw new NucleusDataStoreException(msg);
                }
            }
            if (cmd.hasVersionStrategy()) {
                if (cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    int versionNumber = odb.ext().getObjectVersion(oid);
                    objSM.setTransactionalVersion((Object)versionNumber);
                    NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("NeoDatis.Insert.ObjectPersistedWithVersion", (Object)StringUtils.toJVMIDString((Object)pc), objSM.getInternalObjectId(), (Object)("" + versionNumber)));
                } else if (cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    long updateTimestamp = odb.ext().getObjectUpdateDate(oid);
                    Timestamp ts = new Timestamp(updateTimestamp);
                    objSM.setTransactionalVersion((Object)ts);
                    NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("NeoDatis.Insert.ObjectPersistedWithVersion", (Object)StringUtils.toJVMIDString((Object)pc), objSM.getInternalObjectId(), (Object)("" + ts)));
                }
            } else if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.Insert.ObjectPersisted", (Object)StringUtils.toJVMIDString((Object)pc), objSM.getInternalObjectId()));
            }
            objSM.replaceAllLoadedSCOFieldsWithWrappers();
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        sm.provideFields(fieldNumbers, (FieldManager)new PersistFieldManager(sm, false));
        sm.replaceAllLoadedSCOFieldsWithValues();
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        AbstractClassMetaData cmd = sm.getClassMetaData();
        try {
            ODB odb = (ODB)mconn.getConnection();
            if (sm.getObjectManager().getTransaction().getOptimistic() && cmd.hasVersionStrategy()) {
                OID oid = null;
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    long idNumber = ((DatastoreUniqueOID)sm.getInternalObjectId()).getKey();
                    oid = new OdbObjectOID(idNumber);
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    oid = odb.getObjectId(sm.getObject());
                }
                if (oid != null) {
                    long ts;
                    VersionMetaData vermd = cmd.getVersionMetaData();
                    if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                        long datastoreVersion = odb.ext().getObjectVersion(oid);
                        if (datastoreVersion > 0L) {
                            this.storeMgr.performVersionCheck(sm, datastoreVersion, vermd);
                        }
                    } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME && (ts = odb.ext().getObjectUpdateDate(oid)) > 0L) {
                        this.storeMgr.performVersionCheck(sm, new Timestamp(ts), vermd);
                    }
                }
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.Update.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            if (!sm.getAllFieldsLoaded()) {
                PersistenceCapable pc = (PersistenceCapable)sm.getObject();
                int[] dirtyFieldNumbers = sm.getDirtyFieldNumbers();
                if (dirtyFieldNumbers != null && dirtyFieldNumbers.length > 0) {
                    PersistenceCapable backupCopy = pc.jdoNewInstance((javax.jdo.spi.StateManager)sm);
                    backupCopy.jdoCopyFields((Object)pc, dirtyFieldNumbers);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.Object.Refreshing", (Object)StringUtils.toJVMIDString((Object)pc)));
                    }
                    pc.jdoCopyFields((Object)backupCopy, dirtyFieldNumbers);
                } else if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.Object.Refreshing", (Object)StringUtils.toJVMIDString((Object)pc)));
                }
            }
            try {
                if (neodatisDebug) {
                    System.out.println(">> updateObject odb.getObjectId(" + StringUtils.toJVMIDString((Object)sm.getObject()) + ")");
                }
                odb.getObjectId(sm.getObject());
            }
            catch (ODBRuntimeException re) {
                throw new NucleusDataStoreException("Object not found when preparing for update " + StringUtils.toJVMIDString((Object)sm.getObject()), (Throwable)re);
            }
            if (neodatisDebug) {
                System.out.println(">> updateObject odb.store(" + StringUtils.toJVMIDString((Object)sm.getObject()) + ")");
            }
            odb.store(sm.getObject());
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
            if (cmd.hasVersionStrategy()) {
                long ts;
                VersionMetaData vermd = cmd.getVersionMetaData();
                OID oid = odb.getObjectId(sm.getObject());
                if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    long datastoreVersion = odb.ext().getObjectVersion(oid);
                    if (datastoreVersion > 0L) {
                        sm.setTransactionalVersion((Object)datastoreVersion);
                    }
                } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME && (ts = odb.ext().getObjectUpdateDate(oid)) > 0L) {
                    sm.setTransactionalVersion((Object)new Timestamp(ts));
                }
            }
            sm.replaceAllLoadedSCOFieldsWithWrappers();
        }
        catch (ODBRuntimeException re) {
            throw new NucleusDataStoreException("Exception thrown updating " + StringUtils.toJVMIDString((Object)sm.getObject()) + " in datastore", (Throwable)re);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            ODB odb = (ODB)mconn.getConnection();
            if (sm.getObjectManager().getTransaction().getOptimistic() && cmd.hasVersionStrategy()) {
                OID oid = null;
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    long idNumber = ((DatastoreUniqueOID)sm.getInternalObjectId()).getKey();
                    oid = new OdbObjectOID(idNumber);
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    oid = odb.getObjectId(sm.getObject());
                }
                if (oid != null) {
                    long ts;
                    VersionMetaData vermd = cmd.getVersionMetaData();
                    if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                        long datastoreVersion = odb.ext().getObjectVersion(oid);
                        if (datastoreVersion > 0L) {
                            this.storeMgr.performVersionCheck(sm, datastoreVersion, vermd);
                        }
                    } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME && (ts = odb.ext().getObjectUpdateDate(oid)) > 0L) {
                        this.storeMgr.performVersionCheck(sm, new Timestamp(ts), vermd);
                    }
                }
            }
            sm.loadUnloadedFields();
            try {
                StateManager objSM;
                sm.provideFields(sm.getClassMetaData().getAllMemberPositions(), (FieldManager)new DeleteFieldManager(sm));
                long startTime = System.currentTimeMillis();
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.Delete.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
                }
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    long idNumber = ((DatastoreUniqueOID)sm.getInternalObjectId()).getKey();
                    OdbObjectOID oid = new OdbObjectOID(idNumber);
                    if (neodatisDebug) {
                        System.out.println(">> deleteObject odb.deleteObjectWithId(" + oid + ")");
                    }
                    odb.deleteObjectWithId((OID)oid);
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    if (neodatisDebug) {
                        System.out.println(">> deleteObject odb.delete(" + StringUtils.toJVMIDString((Object)sm.getObject()) + ")");
                    }
                    odb.delete(sm.getObject());
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.ExecutionTime", System.currentTimeMillis() - startTime));
                }
                if (this.storeMgr.getRuntimeManager() != null) {
                    this.storeMgr.getRuntimeManager().incrementDeleteCount();
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled() && (objSM = sm.getObjectManager().findStateManager(sm.getObject())) != null) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("NeoDatis.Delete.ObjectDeleted", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), objSM.getInternalObjectId()));
                }
            }
            catch (ODBRuntimeException re) {
                throw new NucleusDataStoreException("Exception thrown deleting " + StringUtils.toJVMIDString((Object)sm.getObject()) + " from datastore", (Throwable)re);
            }
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Fetching object \"");
            str.append(StringUtils.toJVMIDString((Object)sm.getObject())).append("\" (id=");
            str.append(sm.getObjectManager().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            str.append("]");
            NucleusLogger.PERSISTENCE.debug((Object)str);
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("NeoDatis.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
        }
        try {
            Object pc = this.findObjectForId(sm.getObjectManager(), sm.getInternalObjectId());
            if (pc != null && pc != sm.getObject()) {
                NucleusLogger.PERSISTENCE.info((Object)("Request to populate fields of " + StringUtils.toJVMIDString((Object)sm.getObject()) + " but this object is no longer managed by NeoDatis so replacing with " + StringUtils.toJVMIDString((Object)pc)));
                sm.replaceManagedPC((PersistenceCapable)pc);
            }
        }
        catch (ODBRuntimeException re) {
            re.printStackTrace();
        }
        sm.replaceFields(sm.getClassMetaData().getAllMemberPositions(), (FieldManager)new RetrieveFieldManager(sm));
        this.updateVersionOfManagedObject(sm);
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("NeoDatis.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementFetchCount();
        }
    }

    private Object findObjectForId(ObjectManager om, Object id) {
        Object pc;
        block18: {
            pc = null;
            if (id instanceof DatastoreUniqueOID) {
                long idNumber = ((DatastoreUniqueOID)id).getKey();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                OdbObjectOID oid = new OdbObjectOID(idNumber);
                try {
                    ODB odb = (ODB)mconn.getConnection();
                    if (neodatisDebug) {
                        System.out.println(">> odb.getObjectFromId(" + oid + ")");
                    }
                    if ((pc = odb.getObjectFromId((OID)oid)) == null) {
                        Object var9_13 = null;
                        return var9_13;
                    }
                    break block18;
                }
                catch (ODBRuntimeException re) {
                    throw new NucleusDataStoreException("Exception thrown finding object with id=" + idNumber, (Throwable)re);
                }
                finally {
                    mconn.release();
                }
            }
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            String className = this.storeMgr.getClassNameForObjectID(id, clr, om);
            AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(className, clr);
            if (acmd.getIdentityType() == IdentityType.APPLICATION) {
                Class pcClass = clr.classForName(className, id.getClass().getClassLoader());
                StateManager sm = StateManagerFactory.newStateManagerForHollow((ObjectManager)om, (Class)pcClass, (Object)id);
                Class cls = om.getClassLoaderResolver().classForName(acmd.getFullClassName());
                int[] pkFieldPositions = acmd.getPKMemberPositions();
                ICriterion[] conditions = new ICriterion[pkFieldPositions.length];
                for (int i = 0; i < pkFieldPositions.length; ++i) {
                    Object fieldValue = sm.provideField(pkFieldPositions[i]);
                    String fieldName = acmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldPositions[i]).getName();
                    conditions[i] = Where.equal((String)fieldName, (Object)fieldValue);
                }
                And whereAnd = Where.and();
                for (int i = 0; i < conditions.length; ++i) {
                    whereAnd.add(conditions[i]);
                }
                CriteriaQuery query = new CriteriaQuery(cls, (ICriterion)whereAnd);
                query.setPolymorphic(false);
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                ODB odb = (ODB)mconn.getConnection();
                try {
                    Objects results;
                    if (neodatisDebug) {
                        System.out.println(">> findObjectForId odb.getObjects(criteria for " + cls.getName());
                    }
                    if ((results = odb.getObjects((IQuery)query)) != null && results.size() == 1) {
                        pc = results.getFirst();
                    }
                }
                catch (ODBRuntimeException re) {
                    throw new NucleusDataStoreException("Exception thrown finding object with id=" + id, (Throwable)re);
                }
                finally {
                    mconn.release();
                }
            }
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findObject(ObjectManager om, Object id) {
        Object pc = null;
        try {
            pc = this.findObjectForId(om, id);
        }
        catch (NucleusDataStoreException ndse) {
            throw new NucleusObjectNotFoundException("Exception thrown finding object with id=" + id, ndse.getNestedExceptions());
        }
        StateManager sm = om.findStateManager(pc);
        if (sm == null) {
            AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(pc.getClass(), om.getClassLoaderResolver());
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                ODB odb = (ODB)mconn.getConnection();
                sm = NeoDatisUtils.prepareNeoDatisObjectForUse(pc, om, odb, acmd, this.storeMgr);
            }
            finally {
                mconn.release();
            }
        }
        this.updateVersionOfManagedObject(sm);
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionOfManagedObject(StateManager sm) {
        if (sm.getClassMetaData().hasVersionStrategy()) {
            ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
            try {
                long ts;
                ODB odb = (ODB)mconn.getConnection();
                VersionMetaData vermd = sm.getClassMetaData().getVersionMetaData();
                OID oid = odb.getObjectId(sm.getObject());
                if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    long datastoreVersion = odb.ext().getObjectVersion(oid);
                    if (datastoreVersion > 0L) {
                        sm.setTransactionalVersion((Object)datastoreVersion);
                    }
                } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME && (ts = odb.ext().getObjectUpdateDate(oid)) > 0L) {
                    sm.setTransactionalVersion((Object)new Timestamp(ts));
                }
            }
            finally {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void locateObject(StateManager sm) {
        om = sm.getObjectManager();
        cmd = sm.getClassMetaData();
        mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            odb = (ODB)mconn.getConnection();
            startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)NeoDatisPersistenceHandler.LOCALISER.msg("NeoDatis.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            isStored = false;
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                idNumber = ((DatastoreUniqueOID)sm.getInternalObjectId()).getKey();
                oid = new OdbObjectOID(idNumber);
                try {
                    if (NeoDatisPersistenceHandler.neodatisDebug) {
                        System.out.println(">> locateObject odb.getObjectFromId(" + oid + ")");
                    }
                    if (odb.getObjectFromId((OID)oid) == null) ** GOTO lbl47
                    isStored = true;
                }
                catch (ODBRuntimeException re) {
                    throw new NucleusDataStoreException("Exception thrown locating object with id=" + sm.getInternalObjectId(), (Throwable)re);
                }
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                cls = om.getClassLoaderResolver().classForName(sm.getClassMetaData().getFullClassName());
                acmd = sm.getClassMetaData();
                pkFieldPositions = acmd.getPKMemberPositions();
                conditions = new ICriterion[pkFieldPositions.length];
                for (i = 0; i < pkFieldPositions.length; ++i) {
                    fieldValue = sm.provideField(pkFieldPositions[i]);
                    fieldName = acmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldPositions[i]).getName();
                    conditions[i] = Where.equal((String)fieldName, (Object)fieldValue);
                }
                whereAnd = Where.and();
                for (i = 0; i < conditions.length; ++i) {
                    whereAnd.add(conditions[i]);
                }
                query = new CriteriaQuery(cls, (ICriterion)whereAnd);
                query.setPolymorphic(false);
                try {
                    if (NeoDatisPersistenceHandler.neodatisDebug) {
                        System.out.println(">> locateObject odb.getObjects(criteria for " + cls.getName() + ")");
                    }
                    if ((results = odb.getObjects((IQuery)query)) != null && results.size() == 1) {
                        isStored = true;
                    }
                }
                catch (ODBRuntimeException re) {
                    throw new NucleusDataStoreException("Exception thrown locating object with id=" + sm.getInternalObjectId(), (Throwable)re);
                }
            }
lbl47:
            // 5 sources

            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)NeoDatisPersistenceHandler.LOCALISER.msg("NeoDatis.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (!isStored) {
                throw new NucleusObjectNotFoundException(NeoDatisPersistenceHandler.LOCALISER.msg("NeoDatis.Object.NotFound", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
        }
        finally {
            mconn.release();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OperationInfo {
        List objectsList = null;

        private OperationInfo() {
        }
    }
}

